/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.pkgconfig.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.managedbuilder.pkgconfig.Activator;
import org.eclipse.cdt.managedbuilder.pkgconfig.preferences.PreferenceStore;
import org.eclipse.cdt.managedbuilder.pkgconfig.util.OSDetector;

public class PkgConfigUtil {
    private static final String UNIX_PATH_SEPARATOR = ":";
    private static final String WINDOWS_PATH_SEPARATOR = ";";
    private static final String PKG_CONFIG = "pkg-config";
    private static final String LIST_PACKAGES = "--list-all";
    private static final String OUTPUT_LIBS = "--libs";
    private static final String OUTPUT_CFLAGS = "--cflags";
    private static final String OUTPUT_ALL = "--cflags --libs";
    private static final String OUTPUT_ONLY_LIB_PATHS = "--libs-only-L";
    private static final String OUTPUT_ONLY_LIB_FILES = "--libs-only-l";

    private static String getPkgOutput(String project, String pkgConfigOptions) {
        List<String> pkgOutputs = PkgConfigUtil.getPkgOutputs(project, pkgConfigOptions);
        if (pkgOutputs.isEmpty()) {
            return null;
        }
        return pkgOutputs.get(0);
    }

    private static List<String> getPkgOutputs(String project, String pkgconfigOptions) {
        String[] pkgConfigLibDirPaths;
        ProcessBuilder pb = null;
        String pkgConfigBinPath = PreferenceStore.getPkgConfigBinPath(project);
        if (pkgConfigBinPath.isEmpty()) {
            pkgConfigBinPath = OSDetector.isWindows() ? "pkg-config.exe" : PKG_CONFIG;
        }
        String[] pkgConfigPaths = PreferenceStore.getPkgConfigPath(project);
        StringBuffer pkgConfigCmd = new StringBuffer();
        String pkgConfigPath = "";
        if (pkgConfigPaths != null) {
            int i = 0;
            while (i < pkgConfigPaths.length) {
                String pkgConfigPathValue = pkgConfigPaths[i];
                pkgConfigPath = String.valueOf(pkgConfigPath) + pkgConfigPathValue;
                if (i != pkgConfigPaths.length - 1) {
                    pkgConfigPath = OSDetector.isWindows() ? String.valueOf(pkgConfigPath) + WINDOWS_PATH_SEPARATOR : String.valueOf(pkgConfigPath) + UNIX_PATH_SEPARATOR;
                }
                ++i;
            }
            if (!pkgConfigPath.isEmpty()) {
                pkgConfigPath = pkgConfigPath.replace(" ", "\\ ");
                if (OSDetector.isWindows()) {
                    pkgConfigCmd.append(" set PKG_CONFIG_PATH=" + pkgConfigPath + "&");
                } else {
                    pkgConfigCmd.append(" PKG_CONFIG_PATH=" + pkgConfigPath + " ");
                }
            }
        }
        if ((pkgConfigLibDirPaths = PreferenceStore.getPkgConfigLibDir(project)) != null) {
            String pkgConfigLibDirPath = "";
            int i = 0;
            while (i < pkgConfigLibDirPaths.length) {
                String pkgConfigPathValue = pkgConfigLibDirPaths[i];
                pkgConfigLibDirPath = String.valueOf(pkgConfigLibDirPath) + pkgConfigPathValue;
                if (pkgConfigPaths != null && i != pkgConfigPaths.length - 1) {
                    pkgConfigPath = OSDetector.isWindows() ? String.valueOf(pkgConfigPath) + WINDOWS_PATH_SEPARATOR : String.valueOf(pkgConfigPath) + UNIX_PATH_SEPARATOR;
                }
                ++i;
            }
            if (!pkgConfigLibDirPath.isEmpty()) {
                pkgConfigLibDirPath = pkgConfigLibDirPath.replace(" ", "\\ ");
                if (OSDetector.isWindows()) {
                    pkgConfigCmd.append(" set PKG_CONFIG_LIBDIR=" + pkgConfigLibDirPath + "&");
                } else {
                    pkgConfigCmd.append(" PKG_CONFIG_LIBDIR=" + pkgConfigLibDirPath + " ");
                }
            }
        }
        pkgConfigCmd.append(pkgConfigBinPath);
        if (pkgconfigOptions != null && !pkgconfigOptions.isEmpty()) {
            pkgConfigCmd.append(" " + pkgconfigOptions);
        }
        pb = OSDetector.isWindows() ? new ProcessBuilder("cmd", "/c", pkgConfigCmd.toString()) : new ProcessBuilder("bash", "-c", pkgConfigCmd.toString());
        return PkgConfigUtil.runCommand(pb);
    }

    private static List<String> runCommand(ProcessBuilder pb) {
        ArrayList<String> results = new ArrayList<String>();
        try {
            String line;
            Process p = pb.start();
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            do {
                if ((line = input.readLine()) == null) continue;
                results.add(line);
            } while (line != null);
            input.close();
        }
        catch (IOException e) {
            Activator.getDefault().log(e, "Starting a process (executing a command line script) failed.");
        }
        return results;
    }

    public static String getAll(String pkg, String project) {
        return PkgConfigUtil.getPkgOutput(project, "--cflags --libs " + pkg);
    }

    public static String getLibs(String pkg, String project) {
        return PkgConfigUtil.getPkgOutput(project, "--libs " + pkg);
    }

    public static String getLibPathsOnly(String pkg, String project) {
        return PkgConfigUtil.getPkgOutput(project, "--libs-only-L " + pkg);
    }

    public static String getLibFilesOnly(String pkg, String project) {
        return PkgConfigUtil.getPkgOutput(project, "--libs-only-l " + pkg);
    }

    public static String getCflags(String pkg, String project) {
        return PkgConfigUtil.getPkgOutput(project, "--cflags " + pkg);
    }

    public static List<String> getAllPackages(String project) {
        return PkgConfigUtil.getPkgOutputs(project, LIST_PACKAGES);
    }
}

