/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.pkgconfig.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICResourceDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.pkgconfig.Activator;
import org.eclipse.cdt.managedbuilder.pkgconfig.preferences.LibDirFieldEditor;
import org.eclipse.cdt.managedbuilder.pkgconfig.preferences.Messages;
import org.eclipse.cdt.managedbuilder.pkgconfig.preferences.PkgConfigPathListEditor;
import org.eclipse.cdt.managedbuilder.pkgconfig.preferences.PkgConfigSettingsDialog;
import org.eclipse.cdt.managedbuilder.pkgconfig.preferences.PreferenceStore;
import org.eclipse.cdt.managedbuilder.pkgconfig.properties.DataModel;
import org.eclipse.cdt.managedbuilder.pkgconfig.properties.DataModelProvider;
import org.eclipse.cdt.managedbuilder.pkgconfig.util.Parser;
import org.eclipse.cdt.managedbuilder.pkgconfig.util.PathToToolOption;
import org.eclipse.cdt.managedbuilder.pkgconfig.util.PkgConfigUtil;
import org.eclipse.cdt.ui.newui.AbstractCPropertyTab;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class PkgConfigPropertyTab
extends AbstractCPropertyTab {
    PkgConfigPathListEditor configPathListEditor;
    LibDirFieldEditor libDirEditor;
    CheckboxTableViewer pkgCfgViewer;
    private Set<Object> previouslyChecked;
    private ArrayList<Object> newItems = new ArrayList();
    private static final int BUTTON_SELECT = 0;
    private static final int BUTTON_DESELECT = 1;
    private static final int BUTTON_ADVANCED = 2;
    private final String PACKAGES = "packages";
    private boolean reindexToggle = false;
    private SashForm sashForm;
    private static final String[] BUTTONS = new String[]{"Select", "Deselect", "Advanced..."};
    private IToolChain selectedToolChain;

    public void createControls(Composite parent) {
        super.createControls(parent);
        this.usercomp.setLayout((Layout)new GridLayout(1, false));
        this.sashForm = new SashForm(this.usercomp, 0);
        this.sashForm.setBackground(this.sashForm.getDisplay().getSystemColor(15));
        this.sashForm.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 5;
        this.sashForm.setLayout((Layout)layout);
        Composite c1 = new Composite((Composite)this.sashForm, 0);
        GridLayout layout2 = new GridLayout(3, false);
        c1.setLayout((Layout)layout2);
        this.pkgCfgViewer = CheckboxTableViewer.newCheckList((Composite)c1, (int)68354);
        final Table tbl = this.pkgCfgViewer.getTable();
        tbl.setHeaderVisible(true);
        tbl.setLinesVisible(true);
        GridData gd = new GridData(768);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        tbl.setLayoutData((Object)gd);
        this.createColumns(c1, (TableViewer)this.pkgCfgViewer);
        this.pkgCfgViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.selectedToolChain = this.getSelectedToolchain();
        this.updatePkgConfigBinPath();
        this.pkgCfgViewer.setInput(new DataModelProvider(this.page.getProject().getName()).getEntries());
        this.pkgCfgViewer.addCheckStateListener((ICheckStateListener)new PkgListener());
        this.pkgCfgViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TableItem itm = tbl.getSelection()[0];
                if (itm.getChecked()) {
                    itm.setChecked(false);
                } else {
                    itm.setChecked(true);
                }
                PkgConfigPropertyTab.this.handleCheckStateChange();
            }
        });
        Composite compositeButtons = new Composite(c1, 0);
        this.initButtons(compositeButtons, BUTTONS);
        this.initializePackageStates();
        this.previouslyChecked = new HashSet<Object>(Arrays.asList(this.getCheckedItems()));
    }

    public void handleTabEvent(int kind, Object data) {
        if (this.selectedToolChain != null && this.selectedToolChain.getId() != this.getSelectedToolchain().getId()) {
            this.selectedToolChain = this.getSelectedToolchain();
            this.updatePkgConfigBinPath();
            if (this.pkgCfgViewer != null) {
                this.pkgCfgViewer.setInput(new DataModelProvider(this.page.getProject().getName()).getEntries());
                this.pkgCfgViewer.refresh();
            }
        }
    }

    private Object[] getCheckedItems() {
        return this.pkgCfgViewer.getCheckedElements();
    }

    void handleCheckStateChange() {
        Object[] checkedItems = this.getCheckedItems();
        if (checkedItems.length > this.previouslyChecked.size()) {
            Object[] objectArray = checkedItems;
            int n = checkedItems.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (!this.previouslyChecked.contains(o)) {
                    this.newItems.add(o);
                }
                ++n2;
            }
            PkgConfigPropertyTab.addPackageValues(this.newItems.toArray(), this.page.getProject());
            this.reindexToggle = true;
        }
        this.saveChecked();
        this.updateData(this.getResDesc());
        this.previouslyChecked = new HashSet<Object>(Arrays.asList(checkedItems));
        this.newItems.clear();
    }

    private static void addPackageValues(Object[] addedItems, IProject proj) {
        Object[] objectArray = addedItems;
        int n = addedItems.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            String cflags = PkgConfigUtil.getCflags(item.toString(), proj.getName());
            String[] optionsArray = Parser.parseCflagOptions(cflags);
            if (optionsArray != null) {
                String[] stringArray = optionsArray;
                int n3 = optionsArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String option = stringArray[n4];
                    PathToToolOption.addOtherFlag(option, proj);
                    ++n4;
                }
            }
            ++n2;
        }
        ManagedBuildManager.saveBuildInfo((IProject)proj, (boolean)true);
    }

    private void initializePackageStates() {
        ICConfigurationDescription desc = this.getResDesc().getConfiguration();
        ICStorageElement strgElem = null;
        try {
            strgElem = desc.getStorage("packages", true);
            TableItem[] items = this.pkgCfgViewer.getTable().getItems();
            String value = null;
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getText().contains("+")) {
                    String newItemName = item.getText().replace("+", "plus");
                    value = strgElem.getAttribute(newItemName);
                } else {
                    value = strgElem.getAttribute(item.getText());
                }
                if (value != null && value.equals("true")) {
                    item.setChecked(true);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            Activator.getDefault().log((Exception)((Object)e), "Initialization of packages failed.");
        }
    }

    private void saveChecked() {
        TableItem[] items;
        ICConfigurationDescription desc = this.getResDesc().getConfiguration();
        ICStorageElement strgElem = null;
        try {
            strgElem = desc.getStorage("packages", true);
        }
        catch (CoreException e) {
            Activator.getDefault().log((Exception)((Object)e), "Getting packages from the storage failed.");
        }
        TableItem[] tableItemArray = items = this.pkgCfgViewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item != null) {
                String chkd = item.getChecked() ? "true" : "false";
                try {
                    String pkgName = item.getText();
                    if (pkgName.contains("+")) {
                        String newPkgName = pkgName.replace("+", "plus");
                        if (strgElem != null) {
                            strgElem.setAttribute(newPkgName, chkd);
                        }
                    } else if (strgElem != null) {
                        strgElem.setAttribute(pkgName, chkd);
                    }
                }
                catch (Exception e) {
                    Activator.getDefault().log(e, "Setting attribute to ICStorageElement failed.");
                }
            }
            ++n2;
        }
    }

    protected void performApply(ICResourceDescription src, ICResourceDescription dst) {
        this.updateData(this.getResDesc());
    }

    protected void performDefaults() {
        this.pkgCfgViewer.setCheckedElements(new Object[0]);
        this.handleCheckStateChange();
    }

    protected void performOK() {
        if (this.reindexToggle) {
            this.rebuiltIndex();
        }
        this.reindexToggle = false;
    }

    protected void updateButtons() {
    }

    protected void updateData(ICResourceDescription cfg) {
        final ICConfigurationDescription confDesc = cfg.getConfiguration();
        ICProjectDescription projDesc = confDesc.getProjectDescription();
        Job j = new Job("Update Pkg-config exernal settings provider"){

            protected IStatus run(IProgressMonitor monitor) {
                LinkedHashSet<String> externalSettingsProviders = new LinkedHashSet<String>(Arrays.asList(confDesc.getExternalSettingsProviderIds()));
                externalSettingsProviders.remove("org.eclipse.cdt.managedbuilder.pkgconfig.extSettings");
                confDesc.setExternalSettingsProviderIds(externalSettingsProviders.toArray(new String[externalSettingsProviders.size()]));
                externalSettingsProviders.add("org.eclipse.cdt.managedbuilder.pkgconfig.extSettings");
                confDesc.setExternalSettingsProviderIds(externalSettingsProviders.toArray(new String[externalSettingsProviders.size()]));
                confDesc.updateExternalSettingsProviders(new String[]{"org.eclipse.cdt.managedbuilder.pkgconfig.extSettings"});
                return Status.OK_STATUS;
            }
        };
        j.setPriority(10);
        j.schedule();
        try {
            CoreModel.getDefault().setProjectDescription(this.page.getProject(), projDesc);
        }
        catch (CoreException e) {
            Activator.getDefault().log((Exception)((Object)e), "Setting/updating the project description failed.");
        }
    }

    private void createColumns(Composite parent, TableViewer viewer) {
        String[] titles = new String[]{"Packages", "Description"};
        int[] bounds = new int[]{200, 450};
        TableViewerColumn col = this.createTableViewerColumn(titles[0], bounds[0]);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                DataModel dm = (DataModel)element;
                return dm.getPackage();
            }
        });
        col = this.createTableViewerColumn(titles[1], bounds[1]);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                DataModel dm = (DataModel)element;
                return dm.getDescription();
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound) {
        TableViewerColumn viewerColumn = new TableViewerColumn((TableViewer)this.pkgCfgViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        return viewerColumn;
    }

    private TableItem[] getSelected() {
        TableItem[] selected = this.pkgCfgViewer.getTable().getSelection();
        return selected;
    }

    public void buttonPressed(int n) {
        switch (n) {
            case 0: {
                this.selectedButtonPressed();
                break;
            }
            case 1: {
                this.deselectedButtonPressed();
                break;
            }
            case 2: {
                this.advancedButtonPressed();
                break;
            }
        }
        this.updateButtons();
    }

    private void selectedButtonPressed() {
        TableItem[] selected;
        TableItem[] tableItemArray = selected = this.getSelected();
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem itm = tableItemArray[n2];
            itm.setChecked(true);
            ++n2;
        }
        this.handleCheckStateChange();
    }

    private void deselectedButtonPressed() {
        TableItem[] selected;
        TableItem[] tableItemArray = selected = this.getSelected();
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem itm = tableItemArray[n2];
            itm.setChecked(false);
            ++n2;
        }
        this.handleCheckStateChange();
    }

    private void advancedButtonPressed() {
        PkgConfigSettingsDialog dialog = new PkgConfigSettingsDialog(this.usercomp.getShell(), Messages.PkgConfigPropertyTab_0, this.page.getProject());
        dialog.open();
        if (this.pkgCfgViewer != null) {
            this.updatePkgConfigBinPath();
            this.pkgCfgViewer.setInput(new DataModelProvider(this.page.getProject().getName()).getEntries());
        }
    }

    private void updatePkgConfigBinPath() {
        String pkgConfigPath = "";
        if (this.page != null && PreferenceStore.isPkgConfigExecutableDefault(this.page.getProject().getName())) {
            ITool[] iToolArray = this.selectedToolChain.getToolsBySuperClassId("org.eclipse.cdt.managedbuilder.pkgconfig.tool");
            int n = iToolArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                pkgConfigPath = tool.getToolCommand();
                ++n2;
            }
            PreferenceStore.setPkgConfigBinPath(pkgConfigPath, this.page.getProject().getName());
        }
    }

    private IToolChain getSelectedToolchain() {
        IManagedBuildInfo info;
        if (this.page != null && (info = ManagedBuildManager.getBuildInfo((IResource)this.page.getProject())) != null) {
            return info.getDefaultConfiguration().getToolChain();
        }
        return null;
    }

    private void rebuiltIndex() {
        ICProject cproject = CoreModel.getDefault().getCModel().getCProject(this.page.getProject().getName());
        CCorePlugin.getIndexManager().reindex(cproject);
    }

    public class PkgListener
    implements ICheckStateListener {
        public void checkStateChanged(CheckStateChangedEvent e) {
            PkgConfigPropertyTab.this.handleCheckStateChange();
        }
    }
}

