/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.buildmodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.buildmodel.IConfigurationBuildState;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class ConfigurationBuildState
implements IConfigurationBuildState {
    private static final Integer REBUILD_STATE = new Integer(1);
    private static final Integer REMOVED_STATE = new Integer(2);
    private static final Integer NONE_STATE = new Integer(0);
    private HashMap<Integer, Set<String>> fStateToPathListMap;
    private Properties fPathToStateProps;
    private String fCfgId;
    private IProject fProject;
    private int fState;

    ConfigurationBuildState(IProject project, String cfgId) {
        this.fCfgId = cfgId;
        this.fProject = project;
        this.fState = 1;
    }

    void setProject(IProject project) {
        this.fProject = project;
    }

    @Override
    public IPath[] getFullPathsForState(int state) {
        if (this.fStateToPathListMap == null) {
            return new IPath[0];
        }
        Set<String> set = this.fStateToPathListMap.get(new Integer(state));
        if (set == null) {
            return new IPath[0];
        }
        return this.setToFullPaths(set);
    }

    private IPath[] setToFullPaths(Set<String> set) {
        IPath[] paths = new IPath[set.size()];
        IPath path = this.fProject.getFullPath();
        int num = 0;
        for (String projRel : set) {
            paths[num++] = path.append(projRel);
        }
        return paths;
    }

    @Override
    public int getStateForFullPath(IPath fullPath) {
        Integer i;
        if (this.fPathToStateProps == null) {
            return 0;
        }
        String str = this.fullPathToString(fullPath);
        String v = this.fPathToStateProps.getProperty(str);
        if (v != null && (i = this.stateToInt(v)) != null) {
            return i;
        }
        return 0;
    }

    @Override
    public void setStateForFullPath(IPath fullPath, int state) {
        Set<String> set;
        String strState;
        Integer iState;
        String str = this.fullPathToString(fullPath);
        int cur = this.getStateForFullPath(fullPath);
        if (cur == state) {
            return;
        }
        if (this.fPathToStateProps == null) {
            this.fPathToStateProps = new Properties();
            this.fStateToPathListMap = new HashMap();
        }
        if ((iState = this.stateToInt(strState = this.stateToString(new Integer(state)))) == null) {
            throw new IllegalArgumentException();
        }
        if (cur != 0) {
            set = this.fStateToPathListMap.get(new Integer(cur));
            set.remove(str);
            if (set.size() == 0) {
                this.fStateToPathListMap.remove(iState);
            }
        }
        if (state != 0) {
            this.fPathToStateProps.setProperty(str, strState);
            set = this.fStateToPathListMap.get(iState);
            if (set == null) {
                set = new HashSet<String>();
                this.fStateToPathListMap.put(iState, set);
            }
            set.add(str);
        } else {
            this.fPathToStateProps.remove(str);
        }
    }

    private String fullPathToString(IPath fullPath) {
        return fullPath.removeFirstSegments(1).toString();
    }

    public void load(InputStream iStream) throws IOException {
        Properties props = new Properties();
        props.load(iStream);
        this.load(props);
    }

    private void load(Properties props) {
        HashMap<Integer, HashSet<String>> map = new HashMap<Integer, HashSet<String>>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            Integer i = this.stateToInt((String)entry.getValue());
            HashSet<String> list = (HashSet<String>)map.get(i);
            if (list == null) {
                list = new HashSet<String>();
                map.put(i, list);
            }
            list.add((String)entry.getKey());
        }
        if (map.size() != 0) {
            this.fStateToPathListMap = map;
            this.fPathToStateProps = props;
        }
        this.fState = 0;
    }

    public void store(OutputStream oStream) throws IOException {
        if (this.fPathToStateProps != null) {
            this.fPathToStateProps.store(oStream, "");
        }
    }

    private Integer stateToInt(String state) {
        try {
            Integer i = new Integer(state);
            if (i.equals(REBUILD_STATE)) {
                return REBUILD_STATE;
            }
            if (i.equals(REMOVED_STATE)) {
                return REMOVED_STATE;
            }
            if (i.equals(NONE_STATE)) {
                return NONE_STATE;
            }
        }
        catch (NumberFormatException e) {
            ManagedBuilderCorePlugin.log(e);
        }
        return null;
    }

    private String stateToString(Integer state) {
        return state.toString();
    }

    @Override
    public int getState() {
        return this.fState;
    }

    @Override
    public void setState(int state) {
        this.fState = state;
        this.clear();
    }

    private void clear() {
        this.fPathToStateProps = null;
        this.fStateToPathListMap = null;
    }

    @Override
    public String getConfigurationId() {
        return this.fCfgId;
    }

    @Override
    public IProject getProject() {
        return this.fProject;
    }

    public boolean exists() {
        return this.fState == 0;
    }
}

