/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.core;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.build.core.scannerconfig.CfgInfoContext;
import org.eclipse.cdt.build.core.scannerconfig.ICfgScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.build.internal.core.scannerconfig2.CfgScannerConfigProfileManager;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.ICommandLauncher;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariableManager;
import org.eclipse.cdt.core.language.settings.providers.IWorkingDirectoryTracker;
import org.eclipse.cdt.core.language.settings.providers.ScannerDiscoveryLegacySupport;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.internal.core.BuildRunnerHelper;
import org.eclipse.cdt.make.core.scannerconfig.IScannerConfigBuilderInfo2;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoConsoleParser;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.scannerconfig.ScannerInfoConsoleParserFactory;
import org.eclipse.cdt.managedbuilder.core.AbstractBuildRunner;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ExternalBuildRunner
extends AbstractBuildRunner {
    private static final int PROGRESS_MONITOR_SCALE = 100;
    private static final int TICKS_STREAM_PROGRESS_MONITOR = 100;
    private static final int TICKS_DELETE_MARKERS = 100;
    private static final int TICKS_EXECUTE_COMMAND = 100;
    private static final int TICKS_REFRESH_PROJECT = 100;

    @Override
    public boolean invokeBuild(int kind, IProject project, IConfiguration configuration, IBuilder builder, IConsole console, IMarkerGenerator markerGenerator, IncrementalProjectBuilder projectBuilder, IProgressMonitor monitor) throws CoreException {
        return this.invokeExternalBuild(kind, project, configuration, builder, console, markerGenerator, projectBuilder, monitor);
    }

    protected boolean invokeExternalBuild(int kind, IProject project, IConfiguration configuration, IBuilder builder, IConsole console, IMarkerGenerator markerGenerator, IncrementalProjectBuilder projectBuilder, IProgressMonitor monitor) throws CoreException {
        boolean isClean;
        block15: {
            isClean = false;
            BuildRunnerHelper buildRunnerHelper = new BuildRunnerHelper(project);
            try {
                try {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask(String.valueOf(ManagedMakeMessages.getResourceString("MakeBuilder.Invoking_Make_Builder")) + project.getName(), 400);
                    IPath buildCommand = builder.getBuildCommand();
                    if (buildCommand != null) {
                        String cfgName = configuration.getName();
                        String toolchainName = configuration.getToolChain().getName();
                        boolean isSupported = configuration.isSupported();
                        ICommandLauncher launcher = builder.getCommandLauncher();
                        String[] targets = this.getTargets(kind, builder);
                        if (targets.length != 0 && targets[targets.length - 1].equals(builder.getCleanBuildTarget())) {
                            isClean = true;
                        }
                        boolean isOnlyClean = isClean && targets.length == 1;
                        String[] args = this.getCommandArguments(builder, targets);
                        URI workingDirectoryURI = ManagedBuildManager.getBuildLocationURI(configuration, builder);
                        Map<String, String> envMap = this.getEnvironment(builder);
                        String[] envp = BuildRunnerHelper.envMapToEnvp(envMap);
                        String[] errorParsers = builder.getErrorParsers();
                        ErrorParserManager epm = new ErrorParserManager(project, workingDirectoryURI, markerGenerator, errorParsers);
                        ArrayList<IConsoleParser> parsers = new ArrayList<IConsoleParser>();
                        if (!isOnlyClean) {
                            ICConfigurationDescription cfgDescription = ManagedBuildManager.getDescriptionForConfiguration(configuration);
                            ManagedBuildManager.collectLanguageSettingsConsoleParsers(cfgDescription, (IWorkingDirectoryTracker)epm, parsers);
                            if (ScannerDiscoveryLegacySupport.isLegacyScannerDiscoveryOn((ICConfigurationDescription)cfgDescription)) {
                                ExternalBuildRunner.collectScannerInfoConsoleParsers(project, configuration, workingDirectoryURI, markerGenerator, parsers);
                            }
                        }
                        buildRunnerHelper.setLaunchParameters(launcher, buildCommand, args, workingDirectoryURI, envp);
                        buildRunnerHelper.prepareStreams(epm, parsers, console, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                        buildRunnerHelper.removeOldMarkers((IResource)project, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 4));
                        buildRunnerHelper.greeting(kind, cfgName, toolchainName, isSupported);
                        int state = buildRunnerHelper.build((IProgressMonitor)new SubProgressMonitor(monitor, 100, 4));
                        buildRunnerHelper.close();
                        buildRunnerHelper.goodbye();
                        if (state != -1) {
                            buildRunnerHelper.refreshProject(cfgName, (IProgressMonitor)new SubProgressMonitor(monitor, 100, 4));
                        }
                        break block15;
                    }
                    String msg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.undefined.build.command", builder.getId());
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", msg, (Throwable)new Exception()));
                }
                catch (Exception e) {
                    String msg = ManagedMakeMessages.getFormattedString("ManagedMakeBuilder.message.error.build", new String[]{project.getName(), configuration.getName()});
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.managedbuilder.core", msg, (Throwable)e));
                }
            }
            finally {
                try {
                    buildRunnerHelper.close();
                }
                catch (IOException e) {
                    ManagedBuilderCorePlugin.log(e);
                }
                monitor.done();
            }
        }
        return isClean;
    }

    private String[] getCommandArguments(IBuilder builder, String[] targets) {
        String[] builderArgs = CommandLineUtil.argumentsToArray((String)builder.getBuildArguments());
        String[] args = new String[targets.length + builderArgs.length];
        System.arraycopy(builderArgs, 0, args, 0, builderArgs.length);
        System.arraycopy(targets, 0, args, builderArgs.length, targets.length);
        return args;
    }

    protected String[] getTargets(int kind, IBuilder builder) {
        String[] targetsArray = null;
        if (kind != 15 && !builder.isCustomBuilder() && builder.isManagedBuildOn()) {
            IConfiguration cfg = builder.getParent().getParent();
            String preBuildStep = cfg.getPrebuildStep();
            try {
                preBuildStep = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(preBuildStep, "", " ", 3, cfg);
            }
            catch (BuildMacroException buildMacroException) {}
            if (preBuildStep != null && preBuildStep.length() != 0) {
                targetsArray = new String[]{"pre-build", "main-build"};
            }
        }
        if (targetsArray == null) {
            String targets = "";
            switch (kind) {
                case 9: {
                    targets = builder.getAutoBuildTarget();
                    break;
                }
                case 6: 
                case 10: {
                    targets = builder.getIncrementalBuildTarget();
                    break;
                }
                case 15: {
                    targets = builder.getCleanBuildTarget();
                }
            }
            targetsArray = CommandLineUtil.argumentsToArray((String)targets);
        }
        return targetsArray;
    }

    protected Map<String, String> getEnvironment(IBuilder builder) throws CoreException {
        Map<String, String> builderEnv;
        HashMap<String, String> envMap = new HashMap<String, String>();
        if (builder.appendEnvironment()) {
            IEnvironmentVariable[] vars;
            ICConfigurationDescription cfgDes = ManagedBuildManager.getDescriptionForConfiguration(builder.getParent().getParent());
            IEnvironmentVariableManager mngr = CCorePlugin.getDefault().getBuildEnvironmentManager();
            IEnvironmentVariable[] iEnvironmentVariableArray = vars = mngr.getVariables(cfgDes, true);
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                IEnvironmentVariable var = iEnvironmentVariableArray[n2];
                envMap.put(var.getName(), var.getValue());
                ++n2;
            }
        }
        if ((builderEnv = builder.getExpandedEnvironment()) != null) {
            envMap.putAll(builderEnv);
        }
        return envMap;
    }

    @Deprecated
    protected static String[] getEnvStrings(Map<String, String> env) {
        ArrayList<String> strings = new ArrayList<String>(env.size());
        for (Map.Entry<String, String> entry : env.entrySet()) {
            StringBuffer buffer = new StringBuffer(entry.getKey());
            buffer.append('=').append(entry.getValue());
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    private static void collectScannerInfoConsoleParsers(IProject project, IConfiguration cfg, URI workingDirectoryURI, IMarkerGenerator markerGenerator, List<IConsoleParser> parsers) {
        CfgInfoContext context;
        IScannerInfoConsoleParser parser;
        ICfgScannerConfigBuilderInfo2Set container = CfgScannerConfigProfileManager.getCfgScannerConfigBuildInfo(cfg);
        Map<CfgInfoContext, IScannerConfigBuilderInfo2> map = container.getInfoMap();
        String pathFromURI = EFSExtensionManager.getDefault().getPathFromURI(workingDirectoryURI);
        if (pathFromURI == null) {
            pathFromURI = System.getProperty("user.dir");
        }
        Path workingDirectory = new Path(pathFromURI);
        int oldSize = parsers.size();
        if (container.isPerRcTypeDiscovery()) {
            IResourceInfo[] iResourceInfoArray = cfg.getResourceInfos();
            int n = iResourceInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceInfo rcInfo = iResourceInfoArray[n2];
                ITool[] tools = rcInfo instanceof IFileInfo ? ((IFileInfo)rcInfo).getToolsToInvoke() : ((IFolderInfo)rcInfo).getFilteredTools();
                ITool[] iToolArray = tools;
                int n3 = tools.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITool tool = iToolArray[n4];
                    IInputType[] types = tool.getInputTypes();
                    if (types.length != 0) {
                        IInputType[] iInputTypeArray = types;
                        int n5 = types.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IInputType type = iInputTypeArray[n6];
                            CfgInfoContext context2 = new CfgInfoContext(rcInfo, tool, type);
                            IScannerInfoConsoleParser parser2 = ExternalBuildRunner.getScannerInfoConsoleParser(project, map, context2, (IPath)workingDirectory, markerGenerator);
                            if (parser2 != null) {
                                parsers.add((IConsoleParser)parser2);
                            }
                            ++n6;
                        }
                    } else {
                        CfgInfoContext context3 = new CfgInfoContext(rcInfo, tool, null);
                        IScannerInfoConsoleParser parser3 = ExternalBuildRunner.getScannerInfoConsoleParser(project, map, context3, (IPath)workingDirectory, markerGenerator);
                        if (parser3 != null) {
                            parsers.add((IConsoleParser)parser3);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        if (parsers.size() == oldSize && (parser = ExternalBuildRunner.getScannerInfoConsoleParser(project, map, context = new CfgInfoContext(cfg), (IPath)workingDirectory, markerGenerator)) != null) {
            parsers.add((IConsoleParser)parser);
        }
    }

    private static IScannerInfoConsoleParser getScannerInfoConsoleParser(IProject project, Map<CfgInfoContext, IScannerConfigBuilderInfo2> map, CfgInfoContext context, IPath workingDirectory, IMarkerGenerator markerGenerator) {
        return ScannerInfoConsoleParserFactory.getScannerInfoConsoleParser((IProject)project, (InfoContext)context.toInfoContext(), (IPath)workingDirectory, (IScannerConfigBuilderInfo2)map.get(context), (IMarkerGenerator)markerGenerator, null);
    }
}

