/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.pkgconfig.util;

import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.pkgconfig.Activator;
import org.eclipse.cdt.managedbuilder.pkgconfig.util.Separators;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class PathToToolOption {
    private static final String[] inputTypes = new String[]{"cpp", "c"};
    private static final String OtherFlagsOptionName = "Other flags";

    public static void addOtherFlag(String otherFlag, IProject proj) {
        IConfiguration cf;
        if (proj != null && otherFlag.length() > 0 && (cf = PathToToolOption.getActiveBuildConf(proj)) != null) {
            PathToToolOption.addOtherFlagToToolOption(cf, otherFlag);
        }
    }

    private static boolean addOtherFlagToToolOption(IConfiguration cf, String otherFlag) {
        ITool compiler = PathToToolOption.getCompiler(cf);
        if (compiler != null) {
            IOption otherFlagOption = PathToToolOption.getCompilerOtherFlagsOption(cf);
            if (otherFlagOption != null) {
                boolean val = PathToToolOption.addOtherFlagToToolOption(cf, compiler, otherFlagOption, otherFlag);
                return val;
            }
            return false;
        }
        return false;
    }

    private static boolean addOtherFlagToToolOption(IConfiguration cf, ITool cfTool, IOption option, String newOtherFlag) {
        String flags = option.getValue().toString();
        if (flags == null) {
            flags = "";
        }
        if (flags.contains(newOtherFlag)) {
            return false;
        }
        flags = String.valueOf(flags) + " " + newOtherFlag;
        ManagedBuildManager.setOption((IConfiguration)cf, (IHoldsOptions)cfTool, (IOption)option, (String)flags);
        return false;
    }

    private static ITool getCompiler(IConfiguration cf) {
        int i = 0;
        while (i < inputTypes.length) {
            ITool tool = PathToToolOption.getIToolByInputType(cf, inputTypes[i]);
            if (tool != null) {
                return tool;
            }
            ++i;
        }
        return null;
    }

    private static ITool getIToolByInputType(IConfiguration cf, String ext) {
        return cf.getToolFromInputExtension(ext);
    }

    private static IOption getCompilerOtherFlagsOption(IConfiguration cf) {
        ITool cfTool = PathToToolOption.getCompiler(cf);
        String otherFlagsOptionId = PathToToolOption.getOptionIdByName(cfTool, OtherFlagsOptionName);
        return PathToToolOption.getToolOptionType(cfTool, otherFlagsOptionId);
    }

    private static String getOptionIdByName(ITool cfTool, String name) {
        IOption[] options;
        String optionId = null;
        IOption[] iOptionArray = options = cfTool.getOptions();
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            IOption opt = iOptionArray[n2];
            if (opt != null && opt.getName().equalsIgnoreCase(name)) {
                optionId = opt.getId();
                break;
            }
            ++n2;
        }
        return optionId;
    }

    private static IOption getToolOptionType(ITool cfTool, String optionId) {
        return cfTool.getOptionById(optionId);
    }

    public static String[] addNewPathToExistingPathList(String[] existingPaths, String newPath) {
        String path;
        ArrayList<String> newPathList = new ArrayList<String>();
        int i = 0;
        while (i < existingPaths.length) {
            path = existingPaths[i];
            newPathList.add(path);
            ++i;
        }
        String[] newPathArray = newPath.split(Separators.getPathSeparator());
        int i2 = 0;
        while (i2 < newPathArray.length) {
            path = newPathArray[i2];
            newPathList.add(path);
            ++i2;
        }
        String[] newArray = newPathList.toArray(new String[0]);
        return newArray;
    }

    public static IConfiguration getActiveBuildConf(IProject proj) {
        IConfiguration conf = null;
        IManagedBuildInfo info = null;
        try {
            info = ManagedBuildManager.getBuildInfo((IResource)proj);
        }
        catch (Exception e) {
            Activator.getDefault().log(1, e, "Not a managed build project.");
            return conf;
        }
        if (info == null) {
            return conf;
        }
        conf = info.getDefaultConfiguration();
        return conf;
    }
}

