/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.pkgconfig.util;

import java.util.ArrayList;
import java.util.List;

public class Parser {
    public static String[] parseCflagOptions(String s) throws NullPointerException {
        if (s != null) {
            int end = s.indexOf("-I");
            if (end != -1) {
                if (end != 0) {
                    String str = s.substring(0, end - 1);
                    String[] options = str.split(" ");
                    return options;
                }
                if (end == 0) {
                    return null;
                }
            } else {
                int flagStart = s.indexOf("-");
                if (flagStart != -1) {
                    String str = s.substring(flagStart, s.length() - 1);
                    String[] options = str.split(" ");
                    return options;
                }
                return null;
            }
        }
        return null;
    }

    public static String[] parseIncPaths(String s) throws NullPointerException {
        if (s != null) {
            int start = s.indexOf("-I");
            if (start != -1) {
                String str = s.substring(start, s.length() - 1);
                str = str.replace("-I", "");
                String[] incPaths = str.split(" ");
                return incPaths;
            }
            return null;
        }
        return null;
    }

    public static String[] parseLibPaths2(String s) throws NullPointerException {
        if (s != null) {
            String s2 = s.replace("-L", "");
            String[] libPaths = s2.split(" ");
            return libPaths;
        }
        return null;
    }

    public static String[] parseLibs2(String s) throws NullPointerException {
        if (s != null) {
            String libStr = s;
            if (libStr.startsWith("-l")) {
                libStr = libStr.replaceFirst("-l", "");
            }
            libStr = libStr.replace(" -l", " ");
            String[] libs = libStr.split(" ");
            return libs;
        }
        return null;
    }

    public static List<String> parsePackageList(List<String> packages) {
        ArrayList<String> operated = new ArrayList<String>();
        for (String s : packages) {
            int end = s.indexOf(" ");
            operated.add(s.substring(0, end));
        }
        return operated;
    }

    public static List<String> parseDescription(List<String> packages) {
        ArrayList<String> operated = new ArrayList<String>();
        int start = 0;
        for (String s : packages) {
            int ws = s.indexOf(" ");
            int i = 1;
            while (i + ws < s.length()) {
                if (s.charAt(ws + i) != ' ') {
                    start = ws + i;
                    break;
                }
                ++i;
            }
            operated.add(s.substring(start, s.length()));
        }
        return operated;
    }
}

