/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.pkgconfig.settings;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CExternalSetting;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.CLibraryFileEntry;
import org.eclipse.cdt.core.settings.model.CLibraryPathEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CExternalSettingProvider;
import org.eclipse.cdt.managedbuilder.pkgconfig.Activator;
import org.eclipse.cdt.managedbuilder.pkgconfig.util.Parser;
import org.eclipse.cdt.managedbuilder.pkgconfig.util.PathToToolOption;
import org.eclipse.cdt.managedbuilder.pkgconfig.util.PkgConfigUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class PkgConfigExternalSettingProvider
extends CExternalSettingProvider {
    public static final String ID = "org.eclipse.cdt.managedbuilder.pkgconfig.extSettings";
    private static final String PACKAGES = "packages";

    public CExternalSetting[] getSettings(IProject proj, ICConfigurationDescription cfg) {
        if (proj != null) {
            ICLanguageSettingEntry[] includes = PkgConfigExternalSettingProvider.getEntries(proj, 1);
            ICLanguageSettingEntry[] libFiles = PkgConfigExternalSettingProvider.getEntries(proj, 32);
            ICLanguageSettingEntry[] libPaths = PkgConfigExternalSettingProvider.getEntries(proj, 16);
            CExternalSetting includeSettings = new CExternalSetting(null, new String[]{"org.eclipse.cdt.core.cSource", "org.eclipse.cdt.core.cxxSource"}, null, (ICSettingEntry[])includes);
            CExternalSetting libraryFileSettings = new CExternalSetting(null, new String[]{"org.eclipse.cdt.managedbuilder.core.compiledObjectFile"}, null, (ICSettingEntry[])libFiles);
            CExternalSetting libraryPathSettings = new CExternalSetting(null, new String[]{"org.eclipse.cdt.managedbuilder.core.compiledObjectFile"}, null, (ICSettingEntry[])libPaths);
            PkgConfigExternalSettingProvider.addOtherFlagsToTools(proj);
            return new CExternalSetting[]{includeSettings, libraryFileSettings, libraryPathSettings};
        }
        return new CExternalSetting[0];
    }

    private static ICLanguageSettingEntry[] getEntries(IProject proj, int settingEntry) {
        String[] values = null;
        ICLanguageSettingEntry[] newEntries = null;
        ICLanguageSetting lang = PkgConfigExternalSettingProvider.getGCCLanguageSetting(proj);
        if (lang != null) {
            switch (settingEntry) {
                case 1: {
                    values = PkgConfigExternalSettingProvider.getIncludePathsFromCheckedPackages(proj);
                    newEntries = PkgConfigExternalSettingProvider.formIncludePathEntries(values);
                    lang.setSettingEntries(1, newEntries);
                    break;
                }
                case 32: {
                    values = PkgConfigExternalSettingProvider.getLibraryFilesFromCheckedPackages(proj);
                    newEntries = PkgConfigExternalSettingProvider.formLibraryFileEntries(values);
                    lang.setSettingEntries(32, newEntries);
                    break;
                }
                case 16: {
                    values = PkgConfigExternalSettingProvider.getLibraryPathsFromCheckedPackages(proj);
                    newEntries = PkgConfigExternalSettingProvider.formLibraryPathEntries(values);
                    lang.setSettingEntries(16, newEntries);
                    break;
                }
            }
        }
        return newEntries;
    }

    private static ICLanguageSetting getLanguageSetting(IProject proj, String languageId) {
        ICLanguageSetting[] langSettings = PkgConfigExternalSettingProvider.getLanguageSettings(proj);
        ICLanguageSetting lang = null;
        ICLanguageSetting[] iCLanguageSettingArray = langSettings;
        int n = langSettings.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageSetting langSetting = iCLanguageSettingArray[n2];
            String id = langSetting.getLanguageId();
            if (id != null && id.equalsIgnoreCase(languageId)) {
                lang = langSetting;
                return lang;
            }
            ++n2;
        }
        return null;
    }

    private static ICLanguageSetting[] getLanguageSettings(IProject proj) {
        ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(proj);
        ICConfigurationDescription activeConf = projectDescription.getActiveConfiguration();
        ICFolderDescription folderDesc = activeConf.getRootFolderDescription();
        ICLanguageSetting[] langSettings = folderDesc.getLanguageSettings();
        return langSettings;
    }

    private static ICLanguageSetting getGCCLanguageSetting(IProject proj) {
        return PkgConfigExternalSettingProvider.getLanguageSetting(proj, "org.eclipse.cdt.core.gcc");
    }

    private static ICLanguageSettingEntry[] formIncludePathEntries(String[] includes) {
        ArrayList<CIncludePathEntry> incPathEntries = new ArrayList<CIncludePathEntry>();
        String[] stringArray = includes;
        int n = includes.length;
        int n2 = 0;
        while (n2 < n) {
            String inc = stringArray[n2];
            CIncludePathEntry incPathEntry = new CIncludePathEntry((IPath)new Path(inc), 1);
            incPathEntries.add(incPathEntry);
            ++n2;
        }
        return incPathEntries.toArray(new ICLanguageSettingEntry[incPathEntries.size()]);
    }

    private static ICLanguageSettingEntry[] formLibraryFileEntries(String[] libs) {
        ArrayList<CLibraryFileEntry> libEntries = new ArrayList<CLibraryFileEntry>();
        String[] stringArray = libs;
        int n = libs.length;
        int n2 = 0;
        while (n2 < n) {
            String lib = stringArray[n2];
            CLibraryFileEntry libFileEntry = new CLibraryFileEntry(lib, 32);
            libEntries.add(libFileEntry);
            ++n2;
        }
        return libEntries.toArray(new ICLanguageSettingEntry[libEntries.size()]);
    }

    private static ICLanguageSettingEntry[] formLibraryPathEntries(String[] libPaths) {
        ArrayList<CLibraryPathEntry> libPathEntries = new ArrayList<CLibraryPathEntry>();
        String[] stringArray = libPaths;
        int n = libPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String libPath = stringArray[n2];
            CLibraryPathEntry libPathEntry = new CLibraryPathEntry((IPath)new Path(libPath), 16);
            libPathEntries.add(libPathEntry);
            ++n2;
        }
        return libPathEntries.toArray(new ICLanguageSettingEntry[libPathEntries.size()]);
    }

    private static String[] getIncludePathsFromCheckedPackages(IProject proj) {
        ArrayList includeList = new ArrayList();
        String[] pkgs = PkgConfigExternalSettingProvider.getCheckedPackageNames(proj);
        String cflags = null;
        String[] includeArray = null;
        String[] stringArray = pkgs;
        int n = pkgs.length;
        int n2 = 0;
        while (n2 < n) {
            String pkg = stringArray[n2];
            cflags = PkgConfigUtil.getCflags(pkg, proj.getName());
            includeArray = Parser.parseIncPaths(cflags);
            if (includeArray != null) {
                Collections.addAll(includeList, includeArray);
            }
            ++n2;
        }
        return includeList.toArray(new String[includeList.size()]);
    }

    private static String[] getLibraryFilesFromCheckedPackages(IProject proj) {
        ArrayList libList = new ArrayList();
        String[] pkgs = PkgConfigExternalSettingProvider.getCheckedPackageNames(proj);
        String libs = null;
        String[] libArray = null;
        String[] stringArray = pkgs;
        int n = pkgs.length;
        int n2 = 0;
        while (n2 < n) {
            String pkg = stringArray[n2];
            libs = PkgConfigUtil.getLibFilesOnly(pkg, proj.getName());
            libArray = Parser.parseLibs2(libs);
            if (libArray != null) {
                Collections.addAll(libList, libArray);
            }
            ++n2;
        }
        return libList.toArray(new String[libList.size()]);
    }

    private static String[] getLibraryPathsFromCheckedPackages(IProject proj) {
        ArrayList libPathList = new ArrayList();
        String[] pkgs = PkgConfigExternalSettingProvider.getCheckedPackageNames(proj);
        String libPaths = null;
        String[] libPathArray = null;
        String[] stringArray = pkgs;
        int n = pkgs.length;
        int n2 = 0;
        while (n2 < n) {
            String pkg = stringArray[n2];
            libPaths = PkgConfigUtil.getLibPathsOnly(pkg, proj.getName());
            libPathArray = Parser.parseLibPaths2(libPaths);
            if (libPathArray != null) {
                Collections.addAll(libPathList, libPathArray);
            }
            ++n2;
        }
        return libPathList.toArray(new String[libPathList.size()]);
    }

    static String[] getOtherFlagsFromCheckedPackages(IProject proj) {
        ArrayList otherFlagList = new ArrayList();
        String[] pkgs = PkgConfigExternalSettingProvider.getCheckedPackageNames(proj);
        String cflags = null;
        String[] otherFlagArray = null;
        String[] stringArray = pkgs;
        int n = pkgs.length;
        int n2 = 0;
        while (n2 < n) {
            String pkg = stringArray[n2];
            cflags = PkgConfigUtil.getCflags(proj.getName(), pkg);
            otherFlagArray = Parser.parseCflagOptions(cflags);
            if (otherFlagArray != null) {
                Collections.addAll(otherFlagList, otherFlagArray);
            }
            ++n2;
        }
        return otherFlagList.toArray(new String[otherFlagList.size()]);
    }

    private static void addOtherFlagsToTools(final IProject proj) {
        Job j = new Job("Add other flags"){

            protected IStatus run(IProgressMonitor monitor) {
                String[] flags;
                String[] stringArray = flags = PkgConfigExternalSettingProvider.getOtherFlagsFromCheckedPackages(proj);
                int n = flags.length;
                int n2 = 0;
                while (n2 < n) {
                    String flag = stringArray[n2];
                    PathToToolOption.addOtherFlag(flag, proj);
                    ++n2;
                }
                return Status.OK_STATUS;
            }
        };
        j.setPriority(10);
        j.schedule();
    }

    private static ICStorageElement getPackageStorage(IProject proj) {
        try {
            ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(proj);
            ICConfigurationDescription activeConf = projectDescription.getActiveConfiguration();
            ICConfigurationDescription desc = activeConf.getConfiguration();
            ICStorageElement strgElem = null;
            try {
                strgElem = desc.getStorage(PACKAGES, true);
                return strgElem;
            }
            catch (CoreException e) {
                Activator.getDefault().log((Exception)((Object)e), "Getting packages from the storage failed.");
            }
        }
        catch (NullPointerException e) {
            Activator.getDefault().log(e, "Getting project description failed.");
        }
        return null;
    }

    private static String[] getCheckedPackageNames(IProject proj) {
        ICStorageElement pkgStorage = PkgConfigExternalSettingProvider.getPackageStorage(proj);
        String[] pkgNames = pkgStorage.getAttributeNames();
        ArrayList<String> pkgs = new ArrayList<String>();
        String value = null;
        String[] stringArray = pkgNames;
        int n = pkgNames.length;
        int n2 = 0;
        while (n2 < n) {
            String pkgName = stringArray[n2];
            value = pkgStorage.getAttribute(pkgName);
            if (value != null && value.equals("true")) {
                if (pkgName.contains("plus")) {
                    pkgName = pkgName.replace("plus", "+");
                }
                pkgs.add(pkgName);
            }
            ++n2;
        }
        return pkgs.toArray(new String[pkgs.size()]);
    }
}

