/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.autotools.ui.editors.automake;

import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.internal.autotools.ui.editors.automake.AbstractElementListSelectionDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ElementListSelectionDialog
extends AbstractElementListSelectionDialog {
    private List<Object> fElements;

    @Override
    protected void computeResult() {
        this.setResult(this.getWidgetSelection());
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Control result = super.createDialogArea(parent);
        this.setSelectionListElements(this.fElements, false);
        String initialFilter = null;
        if (this.getPrimaryInitialSelection() instanceof String) {
            initialFilter = (String)this.getPrimaryInitialSelection();
        }
        if (initialFilter != null) {
            this.setFilter(initialFilter, true);
        } else {
            this.refilter();
        }
        return result;
    }

    public Object getSelectedElement() {
        return this.getPrimaryResult();
    }

    public Object[] getSelectedElements() {
        return this.getResult();
    }

    @Override
    protected void handleDoubleClick() {
        if (this.verifyCurrentSelection()) {
            this.buttonPressed(0);
        }
    }

    public ElementListSelectionDialog(Shell parent, String title, Image image, ILabelProvider renderer, boolean ignoreCase, boolean multipleSelection) {
        super(parent, title, image, renderer, ignoreCase, multipleSelection);
    }

    public ElementListSelectionDialog(Shell parent, ILabelProvider renderer, boolean ignoreCase, boolean multipleSelection) {
        this(parent, "", null, renderer, ignoreCase, multipleSelection);
    }

    public int open(Object[] elements) {
        return this.open(Arrays.asList(elements));
    }

    public int open(Object[] elements, String initialSelection) {
        return this.open(Arrays.asList(elements), initialSelection);
    }

    public int open(List<Object> elements) {
        this.setElements(elements);
        return this.open();
    }

    public int open(List<Object> elements, String initialSelection) {
        this.setElements(elements);
        this.setInitialSelection(initialSelection);
        return this.open();
    }

    public void setElements(List<Object> elements) {
        this.fElements = elements;
    }
}

