/*
 * Decompiled with CFR 0.152.
 */
package org.buildroot.cdt.toolchain;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.buildroot.cdt.toolchain.BuildrootActivator;
import org.buildroot.cdt.toolchain.BuildrootConfigElement;
import org.buildroot.cdt.toolchain.BuildrootLaunchConfiguration;
import org.buildroot.cdt.toolchain.BuildrootUtils;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElementProvider;

public class BuildrootToolchainsProvider
implements IManagedConfigElementProvider {
    private static final String STRING = "string";
    private static final String ALL = "all";
    private static final String FALSE = "false";

    public IManagedConfigElement[] getConfigElements() {
        String buildrootConfigFilePath = String.valueOf(System.getProperty("user.home")) + File.separator + ".buildroot-eclipse.toolchains";
        return this.parseBuildrootConfiguration(buildrootConfigFilePath);
    }

    private IManagedConfigElement[] parseBuildrootConfiguration(String buildrootConfigFilePath) {
        File file = new File(buildrootConfigFilePath);
        ArrayList<IManagedConfigElement> configElements = new ArrayList<IManagedConfigElement>();
        try {
            Scanner input = new Scanner(file);
            while (input.hasNext()) {
                String nextLine = input.nextLine();
                String[] config = nextLine.split(":");
                String path = config[0];
                String prefix = config[1];
                String architecture = config[2].toUpperCase();
                if (!BuildrootUtils.isCompilerAvailable(path, prefix, "gcc")) continue;
                configElements.addAll(this.registerBuildrootToolchains(path, prefix, architecture));
                BuildrootLaunchConfiguration launchConfiguration = new BuildrootLaunchConfiguration(path, prefix, architecture);
                launchConfiguration.createLaunchConfiguration();
            }
            input.close();
        }
        catch (FileNotFoundException e) {
            BuildrootActivator.getDefault().error("Buildroot configuration file does not exist : " + buildrootConfigFilePath, e);
        }
        return configElements.toArray(new IManagedConfigElement[configElements.size()]);
    }

    private List<IManagedConfigElement> registerBuildrootToolchains(String path, String prefix, String architecture) {
        ArrayList<IManagedConfigElement> configElements = new ArrayList<IManagedConfigElement>();
        configElements.add(this.createToolchain(path, prefix, architecture));
        BuildArtefactType[] buildArtefactTypeArray = BuildArtefactType.values();
        int n = buildArtefactTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BuildArtefactType buildArtefactType = buildArtefactTypeArray[n2];
            configElements.add(this.createProjectType(path, prefix, architecture, buildArtefactType));
            ++n2;
        }
        configElements.add(this.createAutotoolsToolchain(path, prefix, architecture));
        configElements.add(this.createAutotoolsProjectType(path, prefix, architecture));
        return configElements;
    }

    private IManagedConfigElement createAutotoolsToolchain(String path, String prefix, String architecture) {
        BuildrootConfigElement toolchain = new BuildrootConfigElement(BuildrootConfigElement.ManagedConfigElement.TOOLCHAIN);
        toolchain.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.archList, ALL);
        toolchain.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.configurationEnvironmentSupplier, "org.buildroot.cdt.toolchain.BuildrootEnvironmentVariableSupplier");
        toolchain.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.id, this.getAutotoolsToolchainIdentifier(path));
        toolchain.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.isAbstract, FALSE);
        toolchain.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.name, "Autotools " + BuildrootUtils.getToolName(architecture, path, null));
        toolchain.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.osList, "linux");
        toolchain.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.superClass, "org.eclipse.linuxtools.cdt.autotools.core.toolChain");
        toolchain.addChildren(this.createOptions(path, prefix, this.getAutotoolsToolchainIdentifier(path)));
        toolchain.addChild(this.createConfigureTool(path, prefix, architecture));
        toolchain.addChild(this.createAutotoolsTool(path, prefix, architecture, BuildrootToolType.C_COMPILER));
        toolchain.addChild(this.createAutotoolsTool(path, prefix, architecture, BuildrootToolType.CC_COMPILER));
        return toolchain;
    }

    private IManagedConfigElement createAutotoolsTool(String path, String prefix, String architecture, BuildrootToolType toolType) {
        String toolName = null;
        String toolchainSuffix = null;
        String idSuffix = null;
        String toolDescription = null;
        String toolPath = null;
        String natureFilter = null;
        switch (toolType) {
            case C_COMPILER: {
                natureFilter = "both";
                toolName = "gcc";
                toolchainSuffix = "gcc";
                toolPath = BuildrootUtils.getPrefixedToolPath(prefix, path, toolName);
                idSuffix = "autotools.c.compiler";
                toolDescription = "C Compiler";
                break;
            }
            case CC_COMPILER: {
                natureFilter = "ccnature";
                toolName = "g++";
                toolchainSuffix = "gpp";
                toolPath = BuildrootUtils.getPrefixedToolPath(prefix, path, toolName);
                idSuffix = "autotools.cc.compiler";
                toolDescription = "C++ Compiler";
                break;
            }
        }
        BuildrootConfigElement tool = new BuildrootConfigElement(BuildrootConfigElement.ManagedConfigElement.TOOL);
        tool.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.command, toolPath);
        tool.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.commandLineGenerator, "org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineGenerator");
        tool.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.id, this.getIdentifier(path, idSuffix));
        tool.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.isAbstract, FALSE);
        tool.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.name, "Autotools " + BuildrootUtils.getToolName(architecture, path, toolDescription));
        tool.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.natureFilter, natureFilter);
        tool.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.superClass, "org.eclipse.linuxtools.cdt.autotools.core.toolchain.tool." + toolchainSuffix);
        BuildrootConfigElement inputType = new BuildrootConfigElement(BuildrootConfigElement.ManagedConfigElement.INPUT_TYPE);
        inputType.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.superClass, "cdt.managedbuild.tool.gnu.c.compiler.input");
        inputType.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.id, this.getIdentifier(path, String.valueOf(toolType.name().toLowerCase()) + ".input"));
        inputType.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.scannerConfigDiscoveryProfileId, this.getScannerConfigProfileId(path, architecture, toolType));
        tool.addChild(inputType);
        return tool;
    }

    private IManagedConfigElement createConfigureTool(String path, String prefix, String architecture) {
        BuildrootConfigElement tool = new BuildrootConfigElement(BuildrootConfigElement.ManagedConfigElement.TOOL);
        tool.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.id, this.getIdentifier(path, "autotools.tool.configure"));
        tool.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.isAbstract, FALSE);
        tool.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.superClass, "org.eclipse.linuxtools.cdt.autotools.core.tool.configure");
        BuildrootConfigElement option = new BuildrootConfigElement(BuildrootConfigElement.ManagedConfigElement.OPTION);
        option.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.defaultValue, prefix.substring(0, prefix.length() - 1));
        option.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.id, this.getIdentifier(path, "autotools.toolChain.option.host"));
        option.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.isAbstract, FALSE);
        option.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.name, "Host");
        option.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.resourceFilter, ALL);
        option.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.superClass, "org.eclipse.linuxtools.cdt.autotools.core.option.configure.host");
        option.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.valueType, STRING);
        tool.addChild(option);
        return tool;
    }

    private IManagedConfigElement createAutotoolsProjectType(String path, String prefix, String architecture) {
        BuildrootConfigElement projectType = new BuildrootConfigElement(BuildrootConfigElement.ManagedConfigElement.PROJECT_TYPE);
        projectType.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.buildArtefactType, "org.eclipse.linuxtools.cdt.autotools.core.buildArtefactType.autotools");
        projectType.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.id, this.getIdentifier(path, "autotools"));
        projectType.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.isAbstract, FALSE);
        projectType.addChild(this.createAutotoolsConfiguration(path));
        return projectType;
    }

    private IManagedConfigElement createAutotoolsConfiguration(String path) {
        BuildrootConfigElement config = new BuildrootConfigElement(BuildrootConfigElement.ManagedConfigElement.CONFIGURATION);
        config.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.buildProperties, "org.eclipse.linuxtools.cdt.autotools.core.buildType.default");
        config.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.id, this.getIdentifier(path, "autotools.default"));
        config.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.name, "Configuration");
        config.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.parent, "org.eclipse.linuxtools.cdt.autotools.core.configuration.build");
        config.addChild(this.createAutotoolsToolchainRef(path));
        return config;
    }

    private IManagedConfigElement createAutotoolsToolchainRef(String path) {
        BuildrootConfigElement toolchain = new BuildrootConfigElement(BuildrootConfigElement.ManagedConfigElement.TOOLCHAIN);
        toolchain.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.id, this.getIdentifier(path, "autotools.default"));
        toolchain.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.superClass, this.getAutotoolsToolchainIdentifier(path));
        return toolchain;
    }

    private IManagedConfigElement createProjectType(String path, String prefix, String architecture, BuildArtefactType artefactType) {
        BuildrootConfigElement projectType = new BuildrootConfigElement(BuildrootConfigElement.ManagedConfigElement.PROJECT_TYPE);
        projectType.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.buildArtefactType, "org.eclipse.cdt.build.core.buildArtefactType." + artefactType.getValue());
        projectType.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.id, this.getIdentifier(path, artefactType.getValue()));
        projectType.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.isAbstract, FALSE);
        projectType.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.isTest, FALSE);
        projectType.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.projectEnvironmentSupplier, "org.buildroot.cdt.toolchain.managedbuilder.toolchain.BuildrootEnvironmentVariableSupplier");
        new StringBuffer();
        projectType.addChild(this.createConfiguration(path, ConfigurationType.DEBUG, artefactType));
        projectType.addChild(this.createConfiguration(path, ConfigurationType.RELEASE, artefactType));
        return projectType;
    }

    private IManagedConfigElement createConfiguration(String path, ConfigurationType configType, BuildArtefactType artefactType) {
        BuildrootConfigElement config = new BuildrootConfigElement(BuildrootConfigElement.ManagedConfigElement.CONFIGURATION);
        config.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.buildProperties, "org.eclipse.cdt.build.core.buildType=org.eclipse.cdt.build.core.buildType." + configType.name().toLowerCase());
        config.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.cleanCommand, "rm -rf");
        config.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.id, this.getIdentifier(path, String.valueOf(artefactType.getValue()) + "." + configType.toString().toLowerCase()));
        config.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.name, configType.toString().toLowerCase());
        config.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.parent, "cdt.managedbuild.config.gnu.base");
        config.addChild(this.createToolchainRef(path, artefactType, configType));
        return config;
    }

    private IManagedConfigElement createToolchainRef(String path, BuildArtefactType artefactType, ConfigurationType configType) {
        BuildrootConfigElement toolchain = new BuildrootConfigElement(BuildrootConfigElement.ManagedConfigElement.TOOLCHAIN);
        toolchain.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.id, this.getIdentifier(path, String.valueOf(artefactType.getValue()) + "." + configType.name().toLowerCase()));
        toolchain.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.superClass, this.getToolchainIdentifier(path));
        return toolchain;
    }

    private IManagedConfigElement createToolchain(String path, String prefix, String architecture) {
        BuildrootConfigElement toolchain = new BuildrootConfigElement(BuildrootConfigElement.ManagedConfigElement.TOOLCHAIN);
        toolchain.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.archList, ALL);
        toolchain.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.configurationEnvironmentSupplier, "org.buildroot.cdt.toolchain.BuildrootEnvironmentVariableSupplier");
        toolchain.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.id, this.getToolchainIdentifier(path));
        toolchain.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.isAbstract, FALSE);
        toolchain.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.name, BuildrootUtils.getToolName(architecture, path, null));
        toolchain.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.osList, "linux");
        toolchain.addChildren(this.createOptions(path, prefix, this.getToolchainIdentifier(path)));
        toolchain.addChild(this.createTargetPlatform(path, architecture));
        toolchain.addChild(this.createTool(path, prefix, architecture, BuildrootToolType.ASSEMBLER));
        toolchain.addChild(this.createTool(path, prefix, architecture, BuildrootToolType.C_COMPILER));
        toolchain.addChild(this.createTool(path, prefix, architecture, BuildrootToolType.C_LINKER));
        if (BuildrootUtils.isCompilerAvailable(path, prefix, "g++")) {
            toolchain.addChild(this.createTool(path, prefix, architecture, BuildrootToolType.CC_COMPILER));
            toolchain.addChild(this.createTool(path, prefix, architecture, BuildrootToolType.CC_LINKER));
        }
        toolchain.addChild(this.createTool(path, prefix, architecture, BuildrootToolType.PKG_CONFIG));
        toolchain.addChild(this.createBuilder(path, architecture));
        return toolchain;
    }

    private List<IManagedConfigElement> createOptions(String path, String prefix, String toolchainId) {
        ArrayList<IManagedConfigElement> options = new ArrayList<IManagedConfigElement>();
        BuildrootConfigElement optionCategory = new BuildrootConfigElement(BuildrootConfigElement.ManagedConfigElement.OPTION_CATEGORY);
        String optionCategoryId = String.valueOf(toolchainId) + ".optionCategory";
        optionCategory.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.id, optionCategoryId);
        optionCategory.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.name, "Generic Buildroot Settings");
        options.add(optionCategory);
        options.add(this.createPathOption(path, toolchainId, optionCategoryId));
        options.add(this.createPrefixOption(prefix, toolchainId, optionCategoryId));
        return options;
    }

    private IManagedConfigElement createPathOption(String path, String toolchainId, String optionCategoryId) {
        BuildrootConfigElement option = new BuildrootConfigElement(BuildrootConfigElement.ManagedConfigElement.OPTION);
        option.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.category, optionCategoryId);
        option.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.id, String.valueOf(toolchainId) + ".option.path");
        option.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.isAbstract, FALSE);
        option.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.name, "Path");
        option.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.resourceFilter, ALL);
        option.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.value, String.valueOf(path) + "/host/usr/bin");
        option.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.valueType, STRING);
        return option;
    }

    private IManagedConfigElement createPrefixOption(String prefix, String toolchainId, String optionCategoryId) {
        BuildrootConfigElement option = new BuildrootConfigElement(BuildrootConfigElement.ManagedConfigElement.OPTION);
        option.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.category, optionCategoryId);
        option.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.id, String.valueOf(toolchainId) + ".option.prefix");
        option.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.isAbstract, FALSE);
        option.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.name, "Prefix");
        option.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.resourceFilter, ALL);
        option.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.value, prefix);
        option.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.valueType, STRING);
        return option;
    }

    private String getToolchainIdentifier(String path) {
        return this.getIdentifier(path, ".toolchain.base");
    }

    private String getAutotoolsToolchainIdentifier(String path) {
        return this.getIdentifier(path, ".autotools.toolchain.base");
    }

    private IManagedConfigElement createBuilder(String path, String architecture) {
        BuildrootConfigElement builder = new BuildrootConfigElement(BuildrootConfigElement.ManagedConfigElement.BUILDER);
        builder.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.command, "make");
        builder.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.id, this.getIdentifier(path, "builder"));
        builder.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.isAbstract, FALSE);
        builder.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.name, BuildrootUtils.getToolName(architecture, path, "builder"));
        builder.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.isVariableCaseSensitive, FALSE);
        builder.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.superClass, "cdt.managedbuild.target.gnu.builder");
        return builder;
    }

    private IManagedConfigElement createTool(String path, String prefix, String architecture, BuildrootToolType toolType) {
        String toolName = null;
        String idSuffix = null;
        String toolDescription = null;
        String toolPath = null;
        String superClass = null;
        String natureFilter = null;
        switch (toolType) {
            case ASSEMBLER: {
                superClass = "cdt.managedbuild.tool.gnu.assembler";
                natureFilter = "both";
                toolName = "as";
                toolPath = BuildrootUtils.getPrefixedToolPath(prefix, path, toolName);
                idSuffix = "assembler";
                toolDescription = "Assembler";
                break;
            }
            case C_COMPILER: {
                superClass = "cdt.managedbuild.tool.gnu.c.compiler";
                natureFilter = "both";
                toolName = "gcc";
                toolPath = BuildrootUtils.getPrefixedToolPath(prefix, path, toolName);
                idSuffix = "c.compiler";
                toolDescription = "C Compiler";
                break;
            }
            case CC_COMPILER: {
                superClass = "cdt.managedbuild.tool.gnu.cpp.compiler";
                natureFilter = "ccnature";
                toolName = "g++";
                toolPath = BuildrootUtils.getPrefixedToolPath(prefix, path, toolName);
                idSuffix = "cc.compiler";
                toolDescription = "C++ Compiler";
                break;
            }
            case C_LINKER: {
                superClass = "cdt.managedbuild.tool.gnu.c.linker";
                natureFilter = "cnature";
                toolName = "gcc";
                toolPath = BuildrootUtils.getPrefixedToolPath(prefix, path, toolName);
                idSuffix = "c.linker";
                toolDescription = "C Linker";
                break;
            }
            case CC_LINKER: {
                superClass = "cdt.managedbuild.tool.gnu.cpp.linker";
                natureFilter = "ccnature";
                toolName = "g++";
                toolPath = BuildrootUtils.getPrefixedToolPath(prefix, path, toolName);
                idSuffix = "cc.linker";
                toolDescription = "CC Linker";
                break;
            }
            case PKG_CONFIG: {
                superClass = "org.eclipse.cdt.managedbuilder.pkgconfig.tool";
                natureFilter = "both";
                toolName = "pkg-config";
                toolPath = BuildrootUtils.getToolPath(path, toolName);
                idSuffix = "pkgconfig";
                toolDescription = "Pkg config";
                break;
            }
        }
        BuildrootConfigElement tool = new BuildrootConfigElement(BuildrootConfigElement.ManagedConfigElement.TOOL);
        tool.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.command, toolPath);
        tool.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.commandLineGenerator, "org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineGenerator");
        tool.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.id, this.getIdentifier(path, idSuffix));
        tool.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.isAbstract, FALSE);
        tool.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.name, BuildrootUtils.getToolName(architecture, path, toolDescription));
        tool.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.natureFilter, natureFilter);
        tool.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.superClass, superClass);
        if (toolType == BuildrootToolType.C_COMPILER || toolType == BuildrootToolType.CC_COMPILER) {
            tool.addChild(this.createInputType(path, architecture, toolType, toolPath));
        }
        return tool;
    }

    private IManagedConfigElement createInputType(String path, String architecture, BuildrootToolType toolType, String toolPath) {
        String scannerConfigProfileId = null;
        String superClass = null;
        String id = null;
        switch (toolType) {
            case C_COMPILER: {
                id = this.getIdentifier(path, "c.input");
                scannerConfigProfileId = this.getScannerConfigProfileId(path, architecture, toolType);
                superClass = "cdt.managedbuild.tool.gnu.c.compiler.input";
                break;
            }
            case CC_COMPILER: {
                id = this.getIdentifier(path, "cpp.input");
                scannerConfigProfileId = this.getScannerConfigProfileId(path, architecture, toolType);
                superClass = "cdt.managedbuild.tool.gnu.cpp.compiler.input";
                break;
            }
        }
        BuildrootConfigElement inputType = new BuildrootConfigElement(BuildrootConfigElement.ManagedConfigElement.INPUT_TYPE);
        inputType.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.superClass, superClass);
        inputType.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.id, id);
        inputType.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.scannerConfigDiscoveryProfileId, scannerConfigProfileId);
        StringBuffer buffer = this.createScannerConfigurationDiscoveryProfile(path, architecture, toolType, toolPath);
        BuildrootUtils.registerExtensionPoint(buffer);
        return inputType;
    }

    private StringBuffer createScannerConfigurationDiscoveryProfile(String path, String architecture, BuildrootToolType toolType, String command) {
        StringBuffer buffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("<?eclipse version=\"3.4\"?>");
        buffer.append("<plugin>");
        buffer.append("\t<extension");
        buffer.append("\t\tid=\"" + this.getScannerConfigProfileId(path, architecture, toolType) + "\"");
        buffer.append("\t\tname=\"Buildroot ManagedMakePerProjectProfileC\"");
        buffer.append("\t\tpoint=\"org.eclipse.cdt.make.core.ScannerConfigurationDiscoveryProfile\">");
        buffer.append("\t\t<scannerInfoCollector");
        buffer.append("\t\t\tclass=\"org.buildroot.cdt.toolchain.DefaultGCCScannerInfoCollector\"");
        buffer.append("\t\t\tscope=\"project\">");
        buffer.append("\t\t</scannerInfoCollector>");
        buffer.append("\t\t<buildOutputProvider>");
        buffer.append("\t\t\t<open></open>");
        buffer.append("\t\t\t<scannerInfoConsoleParser");
        buffer.append("\t\t\t\tclass=\"org.buildroot.cdt.toolchain.ManagedGCCScannerInfoConsoleParser\">");
        buffer.append("\t\t\t</scannerInfoConsoleParser>");
        buffer.append("\t\t</buildOutputProvider>");
        buffer.append("\t\t<scannerInfoProvider");
        buffer.append("\t\t\tproviderId=\"specsFile\">");
        buffer.append(" \t\t<run");
        buffer.append("\t\t\t\targuments=\"-E -P -v -dD ${plugin_state_location}/" + this.getSpecFileName(toolType) + "\"");
        buffer.append("\t\t\t\tclass=\"org.eclipse.cdt.make.internal.core.scannerconfig2.GCCSpecsRunSIProvider\"");
        buffer.append("\t\t\t\tcommand=\"" + command + "\">");
        buffer.append("\t\t\t</run>");
        buffer.append("\t\t\t<scannerInfoConsoleParser");
        buffer.append("\t\t\t\tclass=\"org.eclipse.cdt.make.internal.core.scannerconfig.gnu.GCCSpecsConsoleParser\">");
        buffer.append("\t\t\t</scannerInfoConsoleParser>");
        buffer.append("\t\t</scannerInfoProvider>");
        buffer.append("\t</extension>");
        buffer.append("</plugin>");
        return buffer;
    }

    private String getSpecFileName(BuildrootToolType toolType) {
        switch (toolType) {
            case C_COMPILER: {
                return "specs.c";
            }
            case CC_COMPILER: {
                return "specs.cpp";
            }
        }
        return null;
    }

    private String getScannerConfigProfileId(String path, String architecture, BuildrootToolType toolType) {
        switch (toolType) {
            case C_COMPILER: {
                return this.getIdentifier(path, String.valueOf(architecture) + "_ManagedMakePerProjectProfileC");
            }
            case CC_COMPILER: {
                return this.getIdentifier(path, String.valueOf(architecture) + "_ManagedMakePerProjectProfileCPP");
            }
        }
        return null;
    }

    private IManagedConfigElement createTargetPlatform(String path, String architecture) {
        BuildrootConfigElement targetPlatform = new BuildrootConfigElement(BuildrootConfigElement.ManagedConfigElement.TARGET_PLATFORM);
        targetPlatform.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.archList, ALL);
        targetPlatform.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.binaryParser, "org.eclipse.cdt.core.GNU_ELF");
        targetPlatform.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.id, this.getIdentifier(path, "platform.base"));
        targetPlatform.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.isAbstract, FALSE);
        targetPlatform.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.name, BuildrootUtils.getToolName(architecture, path, "Platform"));
        targetPlatform.setAttribute(BuildrootConfigElement.ManagedConfigElementAttribute.osList, "linux");
        return targetPlatform;
    }

    private String getIdentifier(String path, String suffix) {
        if ((path = path.replaceAll("/", ".")).endsWith(".")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.startsWith(".")) {
            path = path.substring(1, path.length());
        }
        return "org.buildroot." + path + "." + suffix;
    }

    private static enum BuildArtefactType {
        CDT_EXE("exe"),
        CDT_SHARED_LIBRARY("sharedLib"),
        CDT_STATIC_LIBRARY("staticLib");

        String value;

        private BuildArtefactType(String val) {
            this.value = val;
        }

        public String getValue() {
            return this.value;
        }
    }

    private static enum BuildrootToolType {
        ASSEMBLER,
        C_COMPILER,
        CC_COMPILER,
        C_LINKER,
        CC_LINKER,
        PKG_CONFIG;

    }

    public static enum ConfigurationType {
        DEBUG,
        RELEASE;

    }
}

