/*
 * Decompiled with CFR 0.152.
 */
package org.buildroot.cdt.toolchain;

import java.util.HashMap;
import java.util.Map;
import org.buildroot.cdt.toolchain.BuildrootDebuggerConfig;
import org.buildroot.cdt.toolchain.BuildrootUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class BuildrootActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.buildroot.cdt.toolchain";
    private static BuildrootActivator plugin;
    private static ILog logger;
    private static Map<String, BuildrootDebuggerConfig> debuggerConfigurations;

    static {
        debuggerConfigurations = new HashMap<String, BuildrootDebuggerConfig>();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        debuggerConfigurations.clear();
        super.stop(context);
    }

    public static BuildrootActivator getDefault() {
        return plugin;
    }

    public static ILog getLogger() {
        return logger;
    }

    public void error(String message, Throwable e) {
        String error = message;
        if (message == null && e != null) {
            error = e.getMessage();
        }
        if (e instanceof CoreException) {
            this.getLog().log(((CoreException)e).getStatus());
        } else {
            Status status = new Status(4, this.getBundle().getSymbolicName(), error, e);
            this.getLog().log((IStatus)status);
        }
    }

    public void warning(String message, Exception e) {
        String warning = message;
        if (message == null && e != null) {
            warning = e.getMessage();
        }
        if (e instanceof CoreException) {
            this.getLog().log(((CoreException)e).getStatus());
        } else {
            Status status = new Status(2, this.getBundle().getSymbolicName(), warning, (Throwable)e);
            this.getLog().log((IStatus)status);
        }
    }

    public static String getSolibPath(String name) {
        return debuggerConfigurations.get(name).getSolibPath();
    }

    public static String getDebugName(String name) {
        return debuggerConfigurations.get(name).getDebugName();
    }

    public static void registerDebuggerConfiguration(String architecture, String prefix, String path) {
        debuggerConfigurations.put(BuildrootUtils.getToolName(architecture, path, null), new BuildrootDebuggerConfig(prefix, path));
    }
}

