/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.pkgconfig;

import java.io.IOException;
import java.util.PropertyResourceBundle;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CProjectDescriptionEvent;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionListener;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.managedbuilder.pkgconfig";
    public static final String TOOL_ID = "org.eclipse.cdt.managedbuilder.pkgconfig.tool";
    private static Activator plugin;
    private static final String PROPERTIES = "plugin.properties";
    private PropertyResourceBundle properties;
    private ICProjectDescriptionListener listener;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.listener = new ICProjectDescriptionListener(){

            public void handleEvent(CProjectDescriptionEvent event) {
                IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)event.getProject());
                IConfiguration cfg = info.getDefaultConfiguration();
                ICProjectDescription projDesc = CoreModel.getDefault().getProjectDescription(event.getProject(), true);
                if (projDesc != null) {
                    final ICConfigurationDescription confDesc = projDesc.getConfigurationById(cfg.getId());
                    Job j = new Job("Update Pkg-config external settings provider"){

                        protected IStatus run(IProgressMonitor monitor) {
                            confDesc.updateExternalSettingsProviders(new String[]{"org.eclipse.cdt.managedbuilder.pkgconfig.extSettings"});
                            return Status.OK_STATUS;
                        }
                    };
                    j.setPriority(10);
                    j.schedule();
                }
            }
        };
        CoreModel.getDefault().addCProjectDescriptionListener(this.listener, 16);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        CoreModel.getDefault().removeCProjectDescriptionListener(this.listener);
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public PropertyResourceBundle getProperties() {
        if (this.properties == null) {
            try {
                this.properties = new PropertyResourceBundle(FileLocator.openStream((Bundle)this.getBundle(), (IPath)new Path(PROPERTIES), (boolean)false));
            }
            catch (IOException e) {
                Activator.getDefault().log(e, "Creating a PropertyResourceBundle failed.");
            }
        }
        return this.properties;
    }

    public void log(Throwable e) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 4, "Error", e));
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public void log(int status, Exception e, String message) {
        this.getLog().log((IStatus)new Status(status, PLUGIN_ID, message, (Throwable)e));
    }

    public void log(Exception e, String message) {
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, message, (Throwable)e));
    }
}

