/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.pkgconfig.preferences;

import org.eclipse.cdt.managedbuilder.pkgconfig.util.ArrayUtil;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferenceStore {
    private static final String PATH_SEPARATOR = ";";
    private static final String PKG_CONFIG_BIN_KIND = "PKG_CONFIG_BIN_KIND";
    private static final String PKG_CONFIG_BIN = "PKG_CONFIG_BIN";
    private static final String PKG_CONFIG_LIBDIR = "PKG_CONFIG_LIBDIR";
    private static final String PKG_CONFIG_PATH = "PKG_CONFIG_PATH";

    public static IEclipsePreferences getPreferenceStore() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.managedbuilder.pkgconfig");
        return prefs;
    }

    public static String getPreferenceStoreValue(String name) {
        return PreferenceStore.getPreferenceStore().get(name, "");
    }

    public static void setPreferenceStoreValue(String name, String value) {
        PreferenceStore.getPreferenceStore().put(name, value);
    }

    public static void clearPreferenceStoreValue(String name) {
        PreferenceStore.getPreferenceStore().put(name, "");
    }

    public static void setPkgConfigExecutable(PkgConfigExecutable pkgConfigExecutable, String project) {
        PreferenceStore.setPreferenceStoreValue(PreferenceStore.getPkgConfigExecutableKey(project), pkgConfigExecutable.toString());
    }

    public static boolean isPkgConfigExecutableDefault(String project) {
        return !PkgConfigExecutable.Custom.name().equals(PreferenceStore.getPreferenceStoreValue(PreferenceStore.getPkgConfigExecutableKey(project)));
    }

    public static void setPkgConfigBinPath(String path, String project) {
        PreferenceStore.setPreferenceStoreValue(PreferenceStore.getPkgConfigBinKey(project), path);
    }

    public static String getPkgConfigBinPath(String project) {
        return PreferenceStore.getPreferenceStoreValue(PreferenceStore.getPkgConfigBinKey(project));
    }

    public static String[] getPkgConfigPath(String project) {
        String pkgConfigPathStringValue = PreferenceStore.getPreferenceStoreValue(PreferenceStore.getPkgConfigPathKey(project));
        if (pkgConfigPathStringValue.length() == 0) {
            return null;
        }
        return pkgConfigPathStringValue.split(PATH_SEPARATOR);
    }

    public static void setPkgConfigPath(String path, String project) {
        String pkgConfigPath = PreferenceStore.getPreferenceStoreValue(PreferenceStore.getPkgConfigPathKey(project));
        if (pkgConfigPath.length() != 0) {
            pkgConfigPath = String.valueOf(pkgConfigPath) + PATH_SEPARATOR;
        }
        PreferenceStore.setPreferenceStoreValue(PreferenceStore.getPkgConfigPathKey(project), String.valueOf(pkgConfigPath) + path);
    }

    public static String[] getPkgConfigLibDir(String project) {
        String pkgConfigLibDirStringValue = PreferenceStore.getPreferenceStoreValue(PreferenceStore.getPkgConfigLibDirKey(project));
        if (pkgConfigLibDirStringValue.length() == 0) {
            return null;
        }
        return pkgConfigLibDirStringValue.split(PATH_SEPARATOR);
    }

    public static void setPkgConfigLibDir(String path, String project) {
        String pkgConfigPath = PreferenceStore.getPreferenceStoreValue(PreferenceStore.getPkgConfigLibDirKey(project));
        if (pkgConfigPath.length() != 0) {
            pkgConfigPath = String.valueOf(pkgConfigPath) + PATH_SEPARATOR;
        }
        PreferenceStore.setPreferenceStoreValue(PreferenceStore.getPkgConfigLibDirKey(project), String.valueOf(pkgConfigPath) + path);
    }

    public static void clearPkgConfigPath(String project) {
        PreferenceStore.clearPreferenceStoreValue(PreferenceStore.getPkgConfigPathKey(project));
    }

    public static void clearPkgConfigLibDir(String project) {
        PreferenceStore.clearPreferenceStoreValue(PreferenceStore.getPkgConfigLibDirKey(project));
    }

    public static String[] getPreferenceStoreValueAsArray(String name) {
        return ArrayUtil.stringToArray(name);
    }

    private static String getPkgConfigBinKey(String project) {
        return "PKG_CONFIG_BIN - " + project;
    }

    private static String getPkgConfigExecutableKey(String project) {
        return "PKG_CONFIG_BIN_KIND - " + project;
    }

    private static String getPkgConfigLibDirKey(String project) {
        return "PKG_CONFIG_LIBDIR - " + project;
    }

    private static String getPkgConfigPathKey(String project) {
        return "PKG_CONFIG_PATH - " + project;
    }

    public static enum PkgConfigExecutable {
        Default,
        Custom;

    }
}

