/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.pkgconfig.preferences;

import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.pkgconfig.preferences.Messages;
import org.eclipse.cdt.managedbuilder.pkgconfig.preferences.PkgConfigPathListEditor;
import org.eclipse.cdt.managedbuilder.pkgconfig.preferences.PreferenceStore;
import org.eclipse.cdt.ui.newui.AbstractPropertyDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PkgConfigSettingsDialog
extends AbstractPropertyDialog {
    private static final String UNSET_PKG_CONFIG = "";
    private static final String PKG_CONFIG_PATH = Messages.PkgConfigSettingsDialog_0;
    private static final String PKG_CONFIG_LIBDIR = Messages.PkgConfigSettingsDialog_1;
    private Combo pkgConfigPathKindCombo;
    private PkgConfigPathListEditor configPathListEditor;
    private Button buttonOk;
    private Button buttonCancel;
    protected String projectName;
    protected IProject project;
    protected String selectedFile;
    private Button radioDefault;
    private Button radioCustom;

    public PkgConfigSettingsDialog(Shell _parent, String title, IProject project) {
        super(_parent, title);
        this.project = project;
        this.projectName = project.getName();
    }

    public void buttonPressed(SelectionEvent e) {
        if (e.widget.equals(this.buttonOk)) {
            int n;
            if (this.radioCustom.getSelection() && this.selectedFile != null) {
                PreferenceStore.setPkgConfigExecutable(PreferenceStore.PkgConfigExecutable.Custom, this.projectName);
                PreferenceStore.setPkgConfigBinPath(this.selectedFile, this.projectName);
            } else {
                PreferenceStore.setPkgConfigExecutable(PreferenceStore.PkgConfigExecutable.Default, this.projectName);
                String pkgConfigPath = UNSET_PKG_CONFIG;
                IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)this.project);
                if (info != null) {
                    ITool[] iToolArray = info.getDefaultConfiguration().getToolChain().getToolsBySuperClassId("org.eclipse.cdt.managedbuilder.pkgconfig.tool");
                    int n2 = iToolArray.length;
                    n = 0;
                    while (n < n2) {
                        ITool tool = iToolArray[n];
                        pkgConfigPath = tool.getToolCommand();
                        ++n;
                    }
                }
                PreferenceStore.setPkgConfigBinPath(pkgConfigPath, this.projectName);
            }
            String pkgConfigPathKind = this.pkgConfigPathKindCombo.getText();
            PreferenceStore.clearPkgConfigLibDir(this.projectName);
            PreferenceStore.clearPkgConfigPath(this.projectName);
            if (pkgConfigPathKind.length() != 0) {
                String[] stringArray = this.configPathListEditor.getPkgConfigPaths();
                n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String pkgConfigPath = stringArray[n3];
                    if (PKG_CONFIG_PATH.equals(pkgConfigPathKind)) {
                        PreferenceStore.setPkgConfigPath(pkgConfigPath, this.projectName);
                    } else if (PKG_CONFIG_LIBDIR.equals(pkgConfigPathKind)) {
                        PreferenceStore.setPkgConfigLibDir(pkgConfigPath, this.projectName);
                    }
                    ++n3;
                }
            }
        }
        this.shell.dispose();
    }

    protected Control createDialogArea(Composite parent) {
        this.shell.setSize(700, 350);
        GridLayout gridLayout = new GridLayout();
        parent.setLayout((Layout)gridLayout);
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(1808);
        composite.setLayoutData((Object)layoutData);
        composite.setLayout((Layout)new GridLayout(1, false));
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText(Messages.PreferencePage_3);
        this.radioDefault = new Button((Composite)group, 16);
        GridData layoutData1 = new GridData(1808);
        layoutData1.horizontalSpan = 2;
        this.radioDefault.setLayoutData((Object)layoutData1);
        boolean isDefaultPkgConfigExecutableSelected = PreferenceStore.isPkgConfigExecutableDefault(this.projectName);
        this.radioDefault.setSelection(isDefaultPkgConfigExecutableSelected);
        this.radioDefault.setText(Messages.PreferencePage_4);
        this.radioCustom = new Button((Composite)group, 16);
        this.radioCustom.setSelection(!isDefaultPkgConfigExecutableSelected);
        this.radioCustom.setText(Messages.PreferencePage_5);
        final Button browseButton = new Button((Composite)group, 8);
        browseButton.setText("Browse...");
        browseButton.setEnabled(!isDefaultPkgConfigExecutableSelected);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String pkgConfigBinPath = PreferenceStore.getPkgConfigBinPath(PkgConfigSettingsDialog.this.projectName);
                FileDialog dialog = new FileDialog(PkgConfigSettingsDialog.this.getShell(), 4096);
                dialog.setFileName(pkgConfigBinPath);
                PkgConfigSettingsDialog.this.selectedFile = dialog.open();
            }
        });
        this.radioDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                browseButton.setEnabled(false);
            }
        });
        this.radioCustom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                browseButton.setEnabled(true);
            }
        });
        Group group2 = new Group(composite, 0);
        group2.setLayoutData((Object)layoutData);
        group2.setLayout((Layout)new GridLayout(2, false));
        Label comboLabel = new Label((Composite)group2, 64);
        GridData comboLabelLayout = new GridData();
        comboLabel.setLayoutData((Object)comboLabelLayout);
        comboLabel.setText(Messages.PkgConfigSettingsDialog_2);
        this.pkgConfigPathKindCombo = new Combo((Composite)group2, 2056);
        GridData comboLayout = new GridData(768);
        this.pkgConfigPathKindCombo.setItems(new String[]{UNSET_PKG_CONFIG, PKG_CONFIG_PATH, PKG_CONFIG_LIBDIR});
        this.pkgConfigPathKindCombo.setLayoutData((Object)comboLayout);
        String[] pkgConfigPath = PreferenceStore.getPkgConfigPath(this.projectName);
        String[] pkgConfigLibDir = PreferenceStore.getPkgConfigLibDir(this.projectName);
        Composite composite2 = new Composite((Composite)group2, 0);
        GridData layoutData2 = new GridData(1808);
        layoutData2.horizontalAlignment = 4;
        layoutData2.horizontalSpan = 3;
        composite2.setLayoutData((Object)layoutData2);
        composite2.setLayout((Layout)new GridLayout(2, false));
        this.configPathListEditor = new PkgConfigPathListEditor("A colon-separated (on Windows, semicolon-separated) list of directories to search for .pc files.", UNSET_PKG_CONFIG, composite2);
        if (pkgConfigLibDir != null) {
            this.pkgConfigPathKindCombo.select(2);
            this.configPathListEditor.setData(pkgConfigLibDir);
        } else if (pkgConfigPath != null) {
            this.pkgConfigPathKindCombo.select(1);
            this.configPathListEditor.setData(pkgConfigPath);
        } else {
            this.pkgConfigPathKindCombo.select(0);
            this.pkgConfigPathKindCombo.setData((Object)UNSET_PKG_CONFIG);
        }
        Composite compButtons = new Composite(composite, 4);
        GridData gd = new GridData(131072, 1024, true, false);
        gd.horizontalSpan = 4;
        compButtons.setLayoutData((Object)gd);
        compButtons.setLayout((Layout)new GridLayout(2, true));
        this.buttonCancel = new Button(compButtons, 8);
        this.buttonCancel.setText(IDialogConstants.CANCEL_LABEL);
        gd = new GridData(768);
        this.buttonCancel.setLayoutData((Object)gd);
        this.buttonCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PkgConfigSettingsDialog.this.buttonPressed(event);
            }
        });
        this.buttonOk = new Button(compButtons, 8);
        this.buttonOk.setText(IDialogConstants.OK_LABEL);
        gd = new GridData(768);
        this.buttonOk.setLayoutData((Object)gd);
        this.buttonOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PkgConfigSettingsDialog.this.buttonPressed(event);
            }
        });
        parent.getShell().setDefaultButton(this.buttonOk);
        return parent;
    }

    protected Shell getShell() {
        return this.shell;
    }
}

