/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.autotools.ui.editors.parser;

import java.util.ArrayList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class AutoconfElement {
    protected String name;
    protected String var;
    protected int startOffset;
    protected int endOffset;
    protected ArrayList<AutoconfElement> children;
    protected AutoconfElement parent;
    private IDocument document;

    public AutoconfElement(String name) {
        this(name, null);
    }

    public AutoconfElement(String name, String var) {
        this.name = name;
        this.var = var;
        this.startOffset = 0;
        this.children = new ArrayList();
    }

    public String toString() {
        String source = this.getSource();
        if (source == null) {
            StringBuffer kids = new StringBuffer();
            for (AutoconfElement kid : this.children) {
                kids.append(kid.toString());
                kids.append(",");
            }
            source = kids.toString();
        }
        return String.valueOf(this.getClass().getSimpleName()) + ": '" + source + "'";
    }

    public void addChild(AutoconfElement element) {
        this.children.add(element);
        if (element.getParent() == null) {
            element.setParent(this);
        }
    }

    public void addSibling(AutoconfElement element) {
        this.parent.addChild(element);
    }

    public AutoconfElement getLastChild() {
        if (this.hasChildren()) {
            return this.children.get(this.children.size() - 1);
        }
        return null;
    }

    public AutoconfElement getParent() {
        return this.parent;
    }

    public void setParent(AutoconfElement parent) {
        this.parent = parent;
    }

    public AutoconfElement[] getChildren() {
        return this.children.toArray(new AutoconfElement[this.children.size()]);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String value) {
        this.var = value;
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public IDocument getDocument() {
        return this.document;
    }

    public void setStartOffset(int offset) {
        this.startOffset = offset;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public void setEndOffset(int offset) {
        this.endOffset = offset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public String getSource() {
        if (this.document != null && this.startOffset >= 0 && this.endOffset >= this.startOffset) {
            try {
                return this.document.get(this.startOffset, this.endOffset - this.startOffset);
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        return null;
    }

    public int getLength() {
        return this.endOffset - this.startOffset;
    }
}

