/*
 * Decompiled with CFR 0.152.
 */
package org.buildroot.cdt.toolchain;

import java.util.ArrayList;
import org.buildroot.cdt.toolchain.BuildrootActivator;
import org.eclipse.cdt.debug.mi.core.IMILaunchConfigurationConstants;
import org.eclipse.cdt.launch.remote.tabs.RemoteCDebuggerTab;
import org.eclipse.cdt.launch.remote.tabs.RemoteCMainTab;
import org.eclipse.cdt.launch.ui.CArgumentsTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;

public class BuildrootLaunchConfigurationTabGroup
extends AbstractLaunchConfigurationTabGroup {
    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        if ("run".equals(mode)) {
            ILaunchConfigurationTab[] tabs = new ILaunchConfigurationTab[]{new RemoteCMainTab(), new CArgumentsTab(), new CommonTab()};
            this.setTabs(tabs);
        } else if ("debug".equals(mode)) {
            ILaunchConfigurationTab[] tabs = new ILaunchConfigurationTab[]{new RemoteCMainTab(), new CArgumentsTab(), new RemoteCDebuggerTab(), new CommonTab()};
            this.setTabs(tabs);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        try {
            String debugName = BuildrootActivator.getDebugName(configuration.getType().getName());
            configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUG_NAME, debugName);
            String solibPath = BuildrootActivator.getSolibPath(configuration.getType().getName());
            ArrayList<String> solibPaths = new ArrayList<String>();
            solibPaths.add(solibPath);
            configuration.setAttribute(IMILaunchConfigurationConstants.ATTR_DEBUGGER_SOLIB_PATH, solibPaths);
        }
        catch (CoreException e) {
            BuildrootActivator.getDefault().error("Launch configuration is not valid", e);
        }
    }
}

