/*
 * Decompiled with CFR 0.152.
 */
package org.buildroot.cdt.toolchain;

import org.buildroot.cdt.toolchain.BuildrootActivator;
import org.buildroot.cdt.toolchain.BuildrootUtils;

public class BuildrootLaunchConfiguration {
    private String path;
    private String prefix;
    private String architecture;

    public BuildrootLaunchConfiguration(String path, String prefix, String architecture) {
        this.path = path;
        this.prefix = prefix;
        this.architecture = architecture;
    }

    public void createLaunchConfiguration() {
        StringBuffer buffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append("<?eclipse version=\"3.4\"?>");
        buffer.append("<plugin>");
        buffer.append(" <extension");
        buffer.append("  point=\"org.eclipse.debug.core.launchConfigurationTypes\">");
        buffer.append("  <launchConfigurationType");
        buffer.append("    delegate=\"org.eclipse.cdt.launch.remote.launching.RemoteRunLaunchDelegate\"");
        buffer.append("    id=\"" + this.getLaunchConfigTypeId() + "\"");
        buffer.append("    modes=\"run,debug\"");
        buffer.append("    name=\"" + BuildrootUtils.getToolName(this.architecture, this.path, null) + "\"");
        buffer.append("    public=\"true\"");
        buffer.append("    sourceLocatorId=\"org.eclipse.cdt.debug.core.sourceLocator\"");
        buffer.append("    sourcePathComputerId=\"org.eclipse.cdt.debug.core.sourcePathComputer\">");
        buffer.append("  </launchConfigurationType>");
        buffer.append(" </extension>");
        buffer.append(" <extension");
        buffer.append("  point=\"org.eclipse.debug.ui.launchConfigurationTabGroups\">");
        buffer.append("  <launchConfigurationTabGroup");
        buffer.append("   class=\"org.buildroot.cdt.toolchain.BuildrootLaunchConfigurationTabGroup\"");
        buffer.append("   id=\"" + this.getLaunchConfigTabGroupId() + "\"");
        buffer.append("   type=\"" + this.getLaunchConfigTypeId() + "\">");
        buffer.append("  </launchConfigurationTabGroup>");
        buffer.append(" </extension>");
        buffer.append(" <extension");
        buffer.append("  point=\"org.eclipse.debug.ui.launchConfigurationTypeImages\">");
        buffer.append("  <launchConfigurationTypeImage");
        buffer.append("   configTypeID=\"" + this.getLaunchConfigTypeId() + "\"");
        buffer.append("   icon=\"icons/br.png\"");
        buffer.append("   id=\"org.buildroot.cdt.toolchain.launchConfigurationTypeImage\">");
        buffer.append("  </launchConfigurationTypeImage>");
        buffer.append(" </extension>");
        buffer.append("</plugin>");
        BuildrootUtils.registerExtensionPoint(buffer);
        BuildrootActivator.registerDebuggerConfiguration(this.architecture, this.prefix, this.path);
    }

    public String getLaunchConfigTypeId() {
        return "org.buildroot.cdt.toolchain.launchConfigurationType." + this.prefix + "." + this.architecture;
    }

    public String getLaunchConfigTabGroupId() {
        return String.valueOf(this.getLaunchConfigTypeId()) + "TabGroup";
    }
}

