/*
 * Decompiled with CFR 0.152.
 */
package org.buildroot.cdt.toolchain;

import java.io.File;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.core.runtime.Platform;

public class BuildrootEnvironmentVariableSupplier
implements IConfigurationEnvironmentVariableSupplier {
    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        if (PathEnvironmentVariable.name.equals(variableName) && PathEnvironmentVariable.isVar(variableName)) {
            return PathEnvironmentVariable.create(configuration);
        }
        if (ToolName.CC.name().equals(variableName)) {
            return ToolEnvironmentVariable.create(configuration, ToolName.CC);
        }
        if (ToolName.CXX.name().equals(variableName)) {
            return ToolEnvironmentVariable.create(configuration, ToolName.CXX);
        }
        if (ToolName.LD.name().equals(variableName)) {
            return ToolEnvironmentVariable.create(configuration, ToolName.LD);
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray;
        PathEnvironmentVariable path = PathEnvironmentVariable.create(configuration);
        IBuildEnvironmentVariable toolCC = ToolEnvironmentVariable.create(configuration, ToolName.CC);
        IBuildEnvironmentVariable toolCXX = ToolEnvironmentVariable.create(configuration, ToolName.CXX);
        IBuildEnvironmentVariable toolLD = ToolEnvironmentVariable.create(configuration, ToolName.LD);
        if (path != null) {
            IBuildEnvironmentVariable[] iBuildEnvironmentVariableArray2 = new IBuildEnvironmentVariable[4];
            iBuildEnvironmentVariableArray2[0] = path;
            iBuildEnvironmentVariableArray2[1] = toolCC;
            iBuildEnvironmentVariableArray2[2] = toolCXX;
            iBuildEnvironmentVariableArray = iBuildEnvironmentVariableArray2;
            iBuildEnvironmentVariableArray2[3] = toolLD;
        } else {
            iBuildEnvironmentVariableArray = new IBuildEnvironmentVariable[]{};
        }
        return iBuildEnvironmentVariableArray;
    }

    private static class PathEnvironmentVariable
    implements IBuildEnvironmentVariable {
        public static String name = "PATH";
        private File path;

        private PathEnvironmentVariable(File path) {
            this.path = path;
        }

        public static PathEnvironmentVariable create(IConfiguration configuration) {
            IToolChain toolchain = configuration.getToolChain();
            while (toolchain.getOptionById(String.valueOf(toolchain.getBaseId()) + ".option.path") == null) {
                toolchain = toolchain.getSuperClass();
            }
            IOption option = toolchain.getOptionById(String.valueOf(toolchain.getBaseId()) + ".option.path");
            String path = (String)option.getValue();
            File sysroot = new File(path);
            File bin = new File(sysroot, "bin");
            if (bin.isDirectory()) {
                sysroot = bin;
            }
            return new PathEnvironmentVariable(sysroot);
        }

        public static boolean isVar(String name) {
            return Platform.getOS().equals("win32") ? name.equalsIgnoreCase(PathEnvironmentVariable.name) : name.equals(PathEnvironmentVariable.name);
        }

        public String getDelimiter() {
            return Platform.getOS().equals("win32") ? ";" : ":";
        }

        public String getName() {
            return name;
        }

        public int getOperation() {
            return 3;
        }

        public String getValue() {
            return this.path.getAbsolutePath();
        }
    }

    private static class ToolEnvironmentVariable
    implements IBuildEnvironmentVariable {
        public String toolName;
        public String varName;
        public String prefix;

        private ToolEnvironmentVariable(String toolName, String varName, String prefix) {
            this.toolName = toolName;
            this.varName = varName;
            this.prefix = prefix;
        }

        public static IBuildEnvironmentVariable create(IConfiguration configuration, ToolName toolName) {
            IToolChain toolchain = configuration.getToolChain();
            while (toolchain.getOptionById(String.valueOf(toolchain.getBaseId()) + ".option.prefix") == null) {
                toolchain = toolchain.getSuperClass();
            }
            IOption option = toolchain.getOptionById(String.valueOf(toolchain.getBaseId()) + ".option.prefix");
            return new ToolEnvironmentVariable(toolName.name(), toolName.getToolName(), (String)option.getValue());
        }

        public String getName() {
            return this.toolName;
        }

        public String getValue() {
            return String.valueOf(this.prefix) + this.varName;
        }

        public int getOperation() {
            return 1;
        }

        public String getDelimiter() {
            return Platform.getOS().equals("win32") ? ";" : ":";
        }
    }

    private static enum ToolName {
        CC("gcc"),
        CXX("g++"),
        LD("ld");

        private String toolName;

        private ToolName(String toolName) {
            this.toolName = toolName;
        }

        public String getToolName() {
            return this.toolName;
        }
    }
}

