################################################################################
#
# linuxconsoletools
#
################################################################################

LINUXCONSOLETOOLS_VERSION = 1.8.1
LINUXCONSOLETOOLS_SOURCE = linuxconsoletools-$(LINUXCONSOLETOOLS_VERSION).tar.bz2
LINUXCONSOLETOOLS_SITE = https://downloads.sourceforge.net/project/linuxconsole
LINUXCONSOLETOOLS_LICENSE = GPL-2.0+
LINUXCONSOLETOOLS_LICENSE_FILES = COPYING

ifneq ($(BR2_PACKAGE_LINUXCONSOLETOOLS_INPUTATTACH),y)
LINUXCONSOLETOOLS_MAKE_OPTS += DISABLE_INPUTATTACH=1
endif

ifneq ($(BR2_PACKAGE_LINUXCONSOLETOOLS_JOYSTICK),y)
LINUXCONSOLETOOLS_MAKE_OPTS += DISABLE_JOYSTICK=1
endif

ifneq ($(BR2_PACKAGE_LINUXCONSOLETOOLS_FORCEFEEDBACK),y)
LINUXCONSOLETOOLS_MAKE_OPTS += DISABLE_FORCEFEEDBACK=1
else
LINUXCONSOLETOOLS_MAKE_OPTS += CFLAGS="$(TARGET_CFLAGS) -std=gnu99"
LINUXCONSOLETOOLS_DEPENDENCIES += sdl2 host-pkgconf
endif

define LINUXCONSOLETOOLS_BUILD_CMDS
	$(TARGET_MAKE_ENV) $(TARGET_CONFIGURE_OPTS) $(MAKE) -C $(@D) \
		$(LINUXCONSOLETOOLS_MAKE_OPTS)
endef

define LINUXCONSOLETOOLS_INSTALL_TARGET_CMDS
	$(TARGET_MAKE_ENV) $(TARGET_CONFIGURE_OPTS) $(MAKE) -C $(@D) \
		$(LINUXCONSOLETOOLS_MAKE_OPTS) \
		DESTDIR="$(TARGET_DIR)" \
		PREFIX=/usr \
		install
endef

$(eval $(generic-package))
