################################################################################
#
# nut
#
################################################################################

NUT_VERSION = 03c3bbe8df9a2caf3c09c120ae7045d35af99b76
NUT_SITE = $(call github,networkupstools,nut,$(NUT_VERSION))
NUT_LICENSE = GPL-2.0+, GPL-3.0+ (python scripts), GPL/Artistic (perl client)
NUT_LICENSE_FILES = COPYING LICENSE-GPL2 LICENSE-GPL3
NUT_SELINUX_MODULES = apache nut
NUT_INSTALL_STAGING = YES
NUT_DEPENDENCIES = host-pkgconf host-perl

# From git:
NUT_AUTORECONF = YES

# Generate files otherwise generated by autogen.sh
# buildroot does not support augeas, creating an empty file prevents
# us from adding a dependency to host-python
define NUT_PREGEN
	touch $(@D)/scripts/augeas/nutupsconf.aug.in
	cd $(@D)/tools && PATH=$(BR_PATH) ./nut-usbinfo.pl
endef
NUT_PRE_CONFIGURE_HOOKS += NUT_PREGEN

# Race condition in tools generation
NUT_MAKE = $(MAKE1)

# Put the PID files in a read-write place (/var/run is a tmpfs)
# since the default location (/var/state/ups) maybe readonly.
NUT_CONF_OPTS = \
	--with-altpidpath=/var/run/upsd \
	--with-dev

NUT_CONF_ENV = ax_cv__printf_string_null=yes

# For uClibc-based toolchains, nut forgets to link with -lm
ifeq ($(BR2_TOOLCHAIN_USES_UCLIBC),y)
NUT_CONF_ENV += LDFLAGS="$(TARGET_LDFLAGS) -lm"
endif

ifeq ($(call qstrip,$(BR2_PACKAGE_NUT_DRIVERS)),)
NUT_CONF_OPTS += --with-drivers=all
else
NUT_CONF_OPTS += --with-drivers=$(BR2_PACKAGE_NUT_DRIVERS)
endif

ifeq ($(BR2_PACKAGE_AVAHI)$(BR2_PACKAGE_DBUS),yy)
NUT_DEPENDENCIES += avahi dbus
NUT_CONF_OPTS += --with-avahi
else
NUT_CONF_OPTS += --without-avahi
endif

# gd with support for png is required for the CGI
ifeq ($(BR2_PACKAGE_GD)$(BR2_PACKAGE_LIBPNG),yy)
NUT_DEPENDENCIES += gd libpng
NUT_CONF_OPTS += --with-cgi
else
NUT_CONF_OPTS += --without-cgi
endif

# nut-scanner needs libltdl, which is a wrapper arounf dlopen/dlsym,
# so is not available for static-only builds.
# There is no flag to directly enable/disable nut-scanner, it's done
# via the --enable/disable-libltdl flag.
ifeq ($(BR2_STATIC_LIBS):$(BR2_PACKAGE_LIBTOOL),:y)
NUT_DEPENDENCIES += libtool
NUT_CONF_OPTS += --with-libltdl
else
NUT_CONF_OPTS += --without-libltdl
endif

ifeq ($(BR2_PACKAGE_LIBUSB_COMPAT),y)
NUT_DEPENDENCIES += libusb-compat
NUT_CONF_OPTS += --with-usb
else
NUT_CONF_OPTS += --without-usb
endif

ifeq ($(BR2_PACKAGE_NEON_EXPAT)$(BR2_PACKAGE_NEON_LIBXML2),y)
NUT_DEPENDENCIES += neon
NUT_CONF_OPTS += --with-neon
else
NUT_CONF_OPTS += --without-neon
endif

ifeq ($(BR2_PACKAGE_NETSNMP),y)
NUT_DEPENDENCIES += netsnmp
NUT_CONF_OPTS += \
	--with-snmp \
	--with-net-snmp-config=$(STAGING_DIR)/usr/bin/net-snmp-config
else
NUT_CONF_OPTS += --without-snmp
endif

ifeq ($(BR2_PACKAGE_OPENSSL),y)
NUT_DEPENDENCIES += openssl
NUT_CONF_OPTS += --with-ssl
else
NUT_CONF_OPTS += --without-ssl
endif

$(eval $(autotools-package))
